/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.repository;

import com.jz.jar.media.repository.MediaBaseRepository;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.UserRecomAudition;
import com.jz.jooq.media.tables.pojos.UserRecomContract;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Table;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class UserRecomRepository
extends MediaBaseRepository {
    private static final com.jz.jooq.media.tables.UserRecomAudition URA = Tables.USER_RECOM_AUDITION;
    private static final com.jz.jooq.media.tables.UserRecomContract URC = Tables.USER_RECOM_CONTRACT;

    public void createAudition(String puid, String brand, String suid, String schoolId, String sourcePuid, int num) {
        this.mediaCtx.insertInto((Table)URA, (Field)UserRecomRepository.URA.PUID, (Field)UserRecomRepository.URA.BRAND, (Field)UserRecomRepository.URA.SUID, (Field)UserRecomRepository.URA.SCHOOL_ID, (Field)UserRecomRepository.URA.SOURCE_PUID, (Field)UserRecomRepository.URA.NUM, (Field)UserRecomRepository.URA.CREATED).values((Object)puid, (Object)brand, (Object)suid, (Object)schoolId, (Object)sourcePuid, (Object)num, (Object)System.currentTimeMillis()).onDuplicateKeyIgnore().execute();
    }

    public UserRecomAudition getAudition(String puid, String brand) {
        return (UserRecomAudition)this.mediaCtx.selectFrom((Table)URA).where(new Condition[]{UserRecomRepository.URA.PUID.eq((Object)puid).and(UserRecomRepository.URA.BRAND.eq((Object)brand))}).fetchAnyInto(UserRecomAudition.class);
    }

    public int cntAuditionBySourcePuid(String sourcePuid, String brand) {
        return this.mediaCtx.fetchCount((Table)URA, UserRecomRepository.URA.SOURCE_PUID.eq((Object)sourcePuid).and(UserRecomRepository.URA.BRAND.eq((Object)brand)));
    }

    public List<UserRecomAudition> getAuditionBySourcePuid(String sourcePuid, String brand, int start, int size) {
        return this.mediaCtx.selectFrom((Table)URA).where(new Condition[]{UserRecomRepository.URA.SOURCE_PUID.eq((Object)sourcePuid).and(UserRecomRepository.URA.BRAND.eq((Object)brand))}).orderBy(UserRecomRepository.URA.CREATED.desc()).limit(start, size).fetchInto(UserRecomAudition.class);
    }

    public void createContract(String contractId, String brand, String puid, String schoolId, String childName, String sourcePuid, int num) {
        this.mediaCtx.insertInto((Table)URC, (Field)UserRecomRepository.URC.CONTRACT_ID, (Field)UserRecomRepository.URC.BRAND, (Field)UserRecomRepository.URC.PUID, (Field)UserRecomRepository.URC.SCHOOL_ID, (Field)UserRecomRepository.URC.CHILD_NAME, (Field)UserRecomRepository.URC.SOURCE_PUID, (Field)UserRecomRepository.URC.NUM, (Field)UserRecomRepository.URC.CREATED).values((Object)contractId, (Object)brand, (Object)puid, (Object)schoolId, (Object)childName, (Object)sourcePuid, (Object)num, (Object)System.currentTimeMillis()).onDuplicateKeyIgnore().execute();
    }

    public UserRecomContract getContract(String contractId, String brand) {
        return (UserRecomContract)this.mediaCtx.selectFrom((Table)URC).where(new Condition[]{UserRecomRepository.URC.CONTRACT_ID.eq((Object)contractId).and(UserRecomRepository.URC.BRAND.eq((Object)brand))}).fetchAnyInto(UserRecomContract.class);
    }

    public int cntContractBySourcePuid(String sourcePuid, String brand) {
        return this.mediaCtx.fetchCount((Table)URC, UserRecomRepository.URC.SOURCE_PUID.eq((Object)sourcePuid).and(UserRecomRepository.URC.BRAND.eq((Object)brand)));
    }

    public List<UserRecomContract> getContractBySourcePuid(String sourcePuid, String brand, int start, int size) {
        return this.mediaCtx.selectFrom((Table)URC).where(new Condition[]{UserRecomRepository.URC.SOURCE_PUID.eq((Object)sourcePuid).and(UserRecomRepository.URC.BRAND.eq((Object)brand))}).orderBy(UserRecomRepository.URC.CREATED.desc()).limit(start, size).fetchInto(UserRecomContract.class);
    }
}

