/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.repository;

import com.jz.jar.media.repository.MediaBaseRepository;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.RedeemActivity;
import com.jz.jooq.media.tables.RedeemActivityBatch;
import com.jz.jooq.media.tables.RedeemGift;
import com.jz.jooq.media.tables.RedeemInfo;
import com.jz.jooq.media.tables.records.RedeemGiftRecord;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class RedeemRepository
extends MediaBaseRepository {
    private static final RedeemActivity RA = Tables.REDEEM_ACTIVITY;
    private static final RedeemActivityBatch RAB = Tables.REDEEM_ACTIVITY_BATCH;
    private static final RedeemInfo RI = Tables.REDEEM_INFO;
    private static final RedeemGift RG = Tables.REDEEM_GIFT;

    public com.jz.jooq.media.tables.pojos.RedeemActivity getActivity(String activityId) {
        return (com.jz.jooq.media.tables.pojos.RedeemActivity)this.mediaCtx.selectFrom((Table)RA).where(new Condition[]{RedeemRepository.RA.ACTIVITY_ID.eq((Object)activityId)}).fetchAnyInto(com.jz.jooq.media.tables.pojos.RedeemActivity.class);
    }

    public Map<String, String> mutiGetActivityId2NameMap(Collection<String> activityIds) {
        return this.mediaCtx.select((SelectField)RedeemRepository.RA.ACTIVITY_ID, (SelectField)RedeemRepository.RA.NAME).from((TableLike)RA).where(new Condition[]{RedeemRepository.RA.ACTIVITY_ID.in(activityIds)}).fetchMap((Field)RedeemRepository.RA.ACTIVITY_ID, (Field)RedeemRepository.RA.NAME);
    }

    public com.jz.jooq.media.tables.pojos.RedeemActivityBatch getBatch(String batchId) {
        return (com.jz.jooq.media.tables.pojos.RedeemActivityBatch)this.mediaCtx.selectFrom((Table)RAB).where(new Condition[]{RedeemRepository.RAB.BATCH_ID.eq((Object)batchId)}).fetchAnyInto(com.jz.jooq.media.tables.pojos.RedeemActivityBatch.class);
    }

    public com.jz.jooq.media.tables.pojos.RedeemInfo getRedeemInfo(String redeemCode) {
        return (com.jz.jooq.media.tables.pojos.RedeemInfo)this.mediaCtx.selectFrom((Table)RI).where(new Condition[]{RedeemRepository.RI.REDEEM_CODE.eq((Object)redeemCode)}).fetchAnyInto(com.jz.jooq.media.tables.pojos.RedeemInfo.class);
    }

    public boolean existOtherJoined(String puid, String activityId) {
        return this.mediaCtx.fetchExists((Table)RI, RedeemRepository.RI.PUID.eq((Object)puid).and(RedeemRepository.RI.ACTIVITY_ID.eq((Object)activityId)));
    }

    public void fetchRedeem(String redeemCode, String puid, String suid, String schoolId, int type, long fetchTime) {
        this.mediaCtx.update((Table)RI).set((Field)RedeemRepository.RI.PUID, (Object)puid).set((Field)RedeemRepository.RI.SUID, (Object)suid).set((Field)RedeemRepository.RI.SCHOOL_ID, (Object)schoolId).set((Field)RedeemRepository.RI.TYPE, (Object)type).set((Field)RedeemRepository.RI.FETCH_TIME, (Object)fetchTime).where(new Condition[]{RedeemRepository.RI.REDEEM_CODE.eq((Object)redeemCode)}).execute();
    }

    public int cntMyRedeemPage(String puid) {
        return this.mediaCtx.fetchCount((Table)RI, RedeemRepository.RI.PUID.eq((Object)puid));
    }

    public List<com.jz.jooq.media.tables.pojos.RedeemInfo> getMyRedeemPage(String puid, int start, int size) {
        return this.mediaCtx.selectFrom((Table)RI).where(new Condition[]{RedeemRepository.RI.PUID.eq((Object)puid)}).orderBy(RedeemRepository.RI.FETCH_TIME.desc()).limit(start, size).fetchInto(com.jz.jooq.media.tables.pojos.RedeemInfo.class);
    }

    public void createGifts(List<RedeemGiftRecord> records) {
        this.mediaCtx.batchInsert(records).execute();
    }

    public List<com.jz.jooq.media.tables.pojos.RedeemGift> getRedeemGifts(String redeemCode) {
        return this.mediaCtx.selectFrom((Table)RG).where(new Condition[]{RedeemRepository.RG.REDEEM_CODE.in((Object[])new String[]{redeemCode})}).orderBy(RedeemRepository.RG.ID.asc()).fetchInto(com.jz.jooq.media.tables.pojos.RedeemGift.class);
    }
}

