package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jar.media.enums.DbField;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.TomatoTagCoursePlaylist;
import com.jz.jooq.media.tables.pojos.TomatoTagInfo;

@Lazy
@Repository
public class TomatoTagRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.TomatoTagInfo TTI = Tables.TOMATO_TAG_INFO;
	private static final com.jz.jooq.media.tables.TomatoTagCoursePlaylist TTCP = Tables.TOMATO_TAG_COURSE_PLAYLIST;

	public List<TomatoTagInfo> listTags(String brand) {
		return mediaCtx.select(TTI.ID, TTI.NAME).from(TTI).where(TTI.BRAND.eq(brand)).orderBy(TTI.SEQ.asc())
				.fetchInto(TomatoTagInfo.class);
	}

	public TomatoTagInfo getTag(String brand, String tid) {
		return mediaCtx.select(TTI.ID, TTI.NAME).from(TTI).where(TTI.BRAND.eq(brand).and(TTI.ID.eq(tid)))
				.fetchAnyInto(TomatoTagInfo.class);
	}

	public List<TomatoTagInfo> mutiGetTags(String brand, Collection<String> tids) {
		return mediaCtx.select(TTI.ID, TTI.NAME).from(TTI).where(TTI.BRAND.eq(brand).and(TTI.ID.in(tids)))
				.fetchInto(TomatoTagInfo.class);
	}

	public int cntOnlineOnSalePCsPage(String brand, String tid) {
		return mediaCtx.fetchCount(
				TTCP,
				TTCP.BRAND.eq(brand).and(TTCP.TID.eq(tid)).and(TTCP.STATUS.eq(DbField.online.name()))
						.and(TTCP.SALE_STATUS.eq(1)));
	}

	public List<TomatoTagCoursePlaylist> getOnlineOnSalePCsPage(String brand, String tid, int start, int size) {
		return mediaCtx
				.select(TTCP.PID, TTCP.TYPE)
				.from(TTCP)
				.where(TTCP.BRAND.eq(brand).and(TTCP.TID.eq(tid)).and(TTCP.STATUS.eq(DbField.online.name()))
						.and(TTCP.SALE_STATUS.eq(1))).orderBy(TTCP.SEQ.desc()).limit(start, size)
				.fetchInto(TomatoTagCoursePlaylist.class);
	}

}
