/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.repository;

import com.google.common.collect.Maps;
import com.jz.jar.media.repository.MediaBaseRepository;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.StudentDayPlay;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.Result;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class StudentDayPlayRepository
extends MediaBaseRepository {
    private static final StudentDayPlay SDP = Tables.STUDENT_DAY_PLAY;

    public void saveTodayPlay(String today, String suid, String pid, int targetCnt, int playCnt, String nextWid) {
        this.mediaCtx.insertInto((Table)SDP, (Field)StudentDayPlayRepository.SDP.DAY, (Field)StudentDayPlayRepository.SDP.SUID, (Field)StudentDayPlayRepository.SDP.PID, (Field)StudentDayPlayRepository.SDP.TARGET_CNT, (Field)StudentDayPlayRepository.SDP.PLAY_CNT, (Field)StudentDayPlayRepository.SDP.NEXT_WID).values((Object)today, (Object)suid, (Object)pid, (Object)targetCnt, (Object)playCnt, (Object)nextWid).onDuplicateKeyUpdate().set((Field)StudentDayPlayRepository.SDP.PLAY_CNT, StudentDayPlayRepository.SDP.PLAY_CNT.add((Number)playCnt)).set((Field)StudentDayPlayRepository.SDP.NEXT_WID, (Object)nextWid).execute();
    }

    public List<String> getTodayCompletePlaylist(String today, String suid, Collection<String> pids) {
        return this.mediaCtx.select((SelectField)StudentDayPlayRepository.SDP.PID).from((TableLike)SDP).where(new Condition[]{StudentDayPlayRepository.SDP.DAY.eq((Object)today).and(StudentDayPlayRepository.SDP.SUID.eq((Object)suid)).and(StudentDayPlayRepository.SDP.PID.in(pids)).and(StudentDayPlayRepository.SDP.PLAY_CNT.ge((Field)StudentDayPlayRepository.SDP.TARGET_CNT))}).fetchInto(String.class);
    }

    public int countLaterDays(String firstDay, String suid) {
        return (Integer)this.mediaCtx.select((SelectField)DSL.countDistinct((Field)StudentDayPlayRepository.SDP.DAY)).from((TableLike)SDP).where(new Condition[]{StudentDayPlayRepository.SDP.DAY.ge((Object)firstDay).and(StudentDayPlayRepository.SDP.SUID.eq((Object)suid))}).fetchAnyInto(Integer.class);
    }

    public Map<String, Integer> getEverdayCompletedPlaylistCount(Collection<String> days, String suid) {
        Result result = this.mediaCtx.select((SelectField)StudentDayPlayRepository.SDP.DAY, (SelectField)DSL.count((Field)StudentDayPlayRepository.SDP.DAY)).from((TableLike)SDP).where(new Condition[]{StudentDayPlayRepository.SDP.DAY.in(days).and(StudentDayPlayRepository.SDP.SUID.eq((Object)suid)).and(StudentDayPlayRepository.SDP.PLAY_CNT.ge((Field)StudentDayPlayRepository.SDP.TARGET_CNT))}).groupBy(new GroupField[]{StudentDayPlayRepository.SDP.DAY}).fetch();
        if (null == result || result.isEmpty()) {
            return Maps.newHashMap();
        }
        HashMap has = Maps.newHashMap();
        result.forEach(it -> {
            Integer cfr_ignored_0 = (Integer)has.put(it.value1(), it.value2());
        });
        return has;
    }
}

