package com.jz.jar.media.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.enums.DbField;
import com.jz.jar.media.repository.UserReadRepository;
import com.jz.jooq.media.tables.pojos.UserRead;

@Lazy
@Service
public class UserReadService {
	
	@Autowired
	private UserReadRepository userReadRepository;

	public void refreshReadTime(String uid, BrandEnum brand, DbField type) {
		userReadRepository.refreshReadTime(uid, brand, type);
	}

	public List<UserRead> getReadTimes(String uid, BrandEnum brand) {
		return userReadRepository.getReadTimes(uid, brand);
	}
	
	public long getReadTime(String uid, BrandEnum brand, DbField type) {
		Long time = userReadRepository.getReadTime(uid, brand, type);
		return null == time ? 0L : time;
	}
}
