package com.jz.jar.media.enums;

import java.util.List;

import com.google.common.collect.Lists;

/**
 * @Title DbField
 * @Package com.jz.jar.media.enums
 * @author tangjunfeng
 * @date 2018年8月15日 下午2:51:40
 * @version V1.0
 */
public enum DbField {

	special("任务-专项练习", null),
	everday("任务-每日任务", null),
	
	wait("专辑-待上线", null),
	online("专辑-上线", null),
	offline("专辑-下线", null),
	delete("专辑-删除", null),
	
	all("系统通知-所有用户", null),
	
	notice("C端消息更新-未读消息数量", "noticeCnt"), 
	newWorks("C端消息更新-关注的人最新作品数量", "followWorksCnt"), 
	sysNotify("C端消息更新-未读系统消息数量", "sysNotifyCnt"),
	
	video("消息/评论-视频", null), 
	works("消息/评论-作品", null), 
	url("消息/banner-链接地址", null), 
	playlist_video("banner-视频专辑", null),
	playlist_imgTxt("banner-图文专辑", null),
	course("banner-在线课程", null),
	theme("banner-专题", null),
	imgTxt("评论-图文", null),
	stc_img("banner-静态图片", null),
	works_topic("banner-艺术馆专题", null),
	
	home("banner展示页面-首页", null),
	wk_recomm("banner展示页面-作品推荐", null),
	tmt_home_theme_right("banner展示页面-首页专题右上角", null),
	;

	private String fieldName;

	DbField(String remarks, String fieldName) {
		this.fieldName = fieldName;
	}

	public String getFieldName() {
		return fieldName;
	}
	
	public static DbField[] getCnts() {
		return new DbField[] { notice, newWorks, sysNotify };
	}
	
	private static final List<DbField> comments = Lists.newArrayList(video, works, imgTxt);

	public boolean isComment() {
		return comments.contains(this);
	}
	
	private static final List<DbField> banners = Lists.newArrayList(playlist_video, playlist_imgTxt, theme, url, works, stc_img, works_topic);
	public boolean isBanner() {
		return banners.contains(this);
	}
}
