package com.jz.jar.media.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.media.repository.TomatoCoursePackRepository;
import com.jz.jooq.media.tables.pojos.TomatoCoursePack;
import com.jz.jooq.media.tables.pojos.TomatoCoursePackVideo;

@Lazy
@Service
public class TomatoCoursePackService {

	@Autowired
	private TomatoCoursePackRepository tomatoCoursePackRepository;

	public TomatoCoursePack getOnlinePack(String pid, String brand) {
		return tomatoCoursePackRepository.getOnlinePack(pid, brand);
	}

	public TomatoCoursePack getOnlinePack(String pid) {
		return tomatoCoursePackRepository.getOnlinePack(pid);
	}

	public List<TomatoCoursePack> mutiGetOnlinePack(Collection<String> pids, String brand) {
		return tomatoCoursePackRepository.mutiGetOnlinePack(pids, brand);
	}

	public Map<String, String> mutiGetPackName(Collection<String> pids) {
		return tomatoCoursePackRepository.mutiGetPackName(pids);
	}

	public List<TomatoCoursePack> mutiGetOnlinePack(Collection<String> pids) {
		return tomatoCoursePackRepository.mutiGetOnlinePack(pids);
	}

	public List<TomatoCoursePackVideo> getPackVideos(String pid) {
		return tomatoCoursePackRepository.getPackVideos(pid);
	}

	public List<String> getPackVideoWids(String pid) {
		return tomatoCoursePackRepository.getPackVideoWids(pid);
	}

	public void increStudyCnt(String pid, int num) {
		tomatoCoursePackRepository.increStudyCnt(pid, num);
	}

	public TomatoCoursePackVideo getPackVideo(String wid, String pid) {
		return tomatoCoursePackRepository.getPackVideo(wid, pid);
	}

	public int cntOnlineOnSalePackPage(String brand, int type) {
		return tomatoCoursePackRepository.cntOnlineOnSalePackPage(brand, type);
	}

	public List<String> getOnlineOnSalePidsPage(String brand, int type, int start, int size) {
		return tomatoCoursePackRepository.getOnlineOnSalePidsPage(brand, type, start, size);
	}

	public List<String> getPidsByWid(String wid) {
		return tomatoCoursePackRepository.getPidsByWid(wid);
	}

	public Integer cntMaster(Collection<String> wids, String pid) {
		return tomatoCoursePackRepository.cntMaster(wids, pid);
	}

}
