/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.repository;

import com.jz.jar.media.repository.MediaBaseRepository;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.AiAbcLessonLike;
import com.jz.jooq.media.tables.AiHomeworkLike;
import com.jz.jooq.media.tables.UserAiDayLearn;
import com.jz.jooq.media.tables.UserAiDayWords;
import com.jz.jooq.media.tables.UserAiLesson;
import com.jz.jooq.media.tables.UserAiLessonSection;
import com.jz.jooq.media.tables.UserAiPack;
import com.jz.jooq.media.tables.pojos.UserAiHomework;
import com.jz.jooq.media.tables.records.UserAiHomeworkRecord;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.Record;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;

@Repository
public class UserAiRepository
extends MediaBaseRepository {
    private static final com.jz.jooq.media.tables.UserAiHomework UAH = Tables.USER_AI_HOMEWORK;
    private static final UserAiPack UAP = Tables.USER_AI_PACK;
    private static final UserAiLesson UAL = Tables.USER_AI_LESSON;
    private static final UserAiLessonSection UALS = Tables.USER_AI_LESSON_SECTION;
    private static final AiHomeworkLike AHL = Tables.AI_HOMEWORK_LIKE;
    private static final UserAiDayLearn UADL = Tables.USER_AI_DAY_LEARN;
    private static final AiAbcLessonLike AALL = Tables.AI_ABC_LESSON_LIKE;
    private static final UserAiDayWords UADW = Tables.USER_AI_DAY_WORDS;

    public List<UserAiHomework> getHomeworks(String suid, String pid, String aid) {
        return this.mediaCtx.selectFrom((Table)UAH).where(new Condition[]{UserAiRepository.UAH.SUID.eq((Object)suid).and(UserAiRepository.UAH.PID.eq((Object)pid)).and(UserAiRepository.UAH.AID.eq((Object)aid))}).fetchInto(UserAiHomework.class);
    }

    public List<UserAiHomework> mutiGetHomework(String suid, String pid, String aid, Collection<String> materialIds) {
        return this.mediaCtx.selectFrom((Table)UAH).where(new Condition[]{UserAiRepository.UAH.SUID.eq((Object)suid).and(UserAiRepository.UAH.PID.eq((Object)pid)).and(UserAiRepository.UAH.AID.eq((Object)aid)).and(UserAiRepository.UAH.MATERIAL_ID.in(materialIds))}).fetchInto(UserAiHomework.class);
    }

    public void savePack(String uid, String suid, String pid, long openTime) {
        this.mediaCtx.insertInto((Table)UAP, (Field)UserAiRepository.UAP.UID, (Field)UserAiRepository.UAP.SUID, (Field)UserAiRepository.UAP.PID, (Field)UserAiRepository.UAP.OPEN_TIME, (Field)UserAiRepository.UAP.CREATE_TIME).values((Object)uid, (Object)suid, (Object)pid, (Object)openTime, (Object)System.currentTimeMillis()).onDuplicateKeyIgnore().execute();
    }

    public com.jz.jooq.media.tables.pojos.UserAiPack getPack(String uid, String pid) {
        return (com.jz.jooq.media.tables.pojos.UserAiPack)this.mediaCtx.selectFrom((Table)UAP).where(new Condition[]{UserAiRepository.UAP.UID.eq((Object)uid).and(UserAiRepository.UAP.PID.eq((Object)pid))}).fetchAnyInto(com.jz.jooq.media.tables.pojos.UserAiPack.class);
    }

    public void saveLesson(String suid, String pid, String aid, int status, String currentSectionId, String currentMaterialId, Long finishTime) {
        long current = System.currentTimeMillis();
        this.mediaCtx.insertInto((Table)UAL, (Field)UserAiRepository.UAL.SUID, (Field)UserAiRepository.UAL.PID, (Field)UserAiRepository.UAL.AID, (Field)UserAiRepository.UAL.STATUS, (Field)UserAiRepository.UAL.CREATE_TIME, (Field)UserAiRepository.UAL.CURRENT_SECTION_ID, (Field)UserAiRepository.UAL.CURRENT_MATERIAL_ID, (Field)UserAiRepository.UAL.FINISH_TIME).values((Object)suid, (Object)pid, (Object)aid, (Object)status, (Object)current, (Object)currentSectionId, (Object)currentMaterialId, (Object)finishTime).onDuplicateKeyUpdate().set((Field)UserAiRepository.UAL.STATUS, (Object)status).set((Field)UserAiRepository.UAL.CURRENT_SECTION_ID, (Object)currentSectionId).set((Field)UserAiRepository.UAL.CURRENT_MATERIAL_ID, (Object)currentMaterialId).set((Field)UserAiRepository.UAL.CREATE_TIME, (Object)current).set((Field)UserAiRepository.UAL.FINISH_TIME, (Object)finishTime).execute();
    }

    public Map<String, Integer> mutiCalFinishNum(String suid, Collection<String> pids) {
        return this.mediaCtx.select((SelectField)UserAiRepository.UAL.PID, (SelectField)DSL.count()).from((TableLike)UAL).where(new Condition[]{UserAiRepository.UAL.SUID.eq((Object)suid).and(UserAiRepository.UAL.PID.in(pids)).and(UserAiRepository.UAL.STATUS.eq((Object)2))}).groupBy(new GroupField[]{UserAiRepository.UAL.PID}).fetchMap((Field)UserAiRepository.UAL.PID, (Field)DSL.count());
    }

    public List<com.jz.jooq.media.tables.pojos.UserAiLesson> getLessons(String suid, String pid) {
        return this.mediaCtx.selectFrom((Table)UAL).where(new Condition[]{UserAiRepository.UAL.SUID.eq((Object)suid).and(UserAiRepository.UAL.PID.eq((Object)pid))}).orderBy(UserAiRepository.UAL.CREATE_TIME.desc()).fetchInto(com.jz.jooq.media.tables.pojos.UserAiLesson.class);
    }

    public com.jz.jooq.media.tables.pojos.UserAiLesson getLesson(String suid, String pid, String aid) {
        return (com.jz.jooq.media.tables.pojos.UserAiLesson)this.mediaCtx.selectFrom((Table)UAL).where(new Condition[]{UserAiRepository.UAL.SUID.eq((Object)suid).and(UserAiRepository.UAL.PID.eq((Object)pid)).and(UserAiRepository.UAL.AID.eq((Object)aid))}).fetchAnyInto(com.jz.jooq.media.tables.pojos.UserAiLesson.class);
    }

    public void saveSection(String suid, String pid, String aid, String sectionId, int status, String currentMaterialId) {
        this.mediaCtx.insertInto((Table)UALS, (Field)UserAiRepository.UALS.SUID, (Field)UserAiRepository.UALS.PID, (Field)UserAiRepository.UALS.AID, (Field)UserAiRepository.UALS.SECTION_ID, (Field)UserAiRepository.UALS.STATUS, (Field)UserAiRepository.UALS.CREATE_TIME, (Field)UserAiRepository.UALS.CURRENT_MATERIAL_ID).values((Object)suid, (Object)pid, (Object)aid, (Object)sectionId, (Object)status, (Object)System.currentTimeMillis(), (Object)currentMaterialId).onDuplicateKeyUpdate().set((Field)UserAiRepository.UALS.STATUS, (Object)status).set((Field)UserAiRepository.UALS.CURRENT_MATERIAL_ID, (Object)currentMaterialId).execute();
    }

    public List<com.jz.jooq.media.tables.pojos.UserAiLessonSection> getSections(String suid, String pid, String aid) {
        return this.mediaCtx.selectFrom((Table)UALS).where(new Condition[]{UserAiRepository.UALS.SUID.eq((Object)suid).and(UserAiRepository.UALS.PID.eq((Object)pid)).and(UserAiRepository.UALS.AID.eq((Object)aid))}).fetchInto(com.jz.jooq.media.tables.pojos.UserAiLessonSection.class);
    }

    public com.jz.jooq.media.tables.pojos.UserAiLessonSection getSection(String suid, String pid, String aid, String sectionId) {
        return (com.jz.jooq.media.tables.pojos.UserAiLessonSection)this.mediaCtx.selectFrom((Table)UALS).where(new Condition[]{UserAiRepository.UALS.SUID.eq((Object)suid).and(UserAiRepository.UALS.PID.eq((Object)pid)).and(UserAiRepository.UALS.AID.eq((Object)aid)).and(UserAiRepository.UALS.SECTION_ID.eq((Object)sectionId))}).fetchAnyInto(com.jz.jooq.media.tables.pojos.UserAiLessonSection.class);
    }

    public Map<Long, Integer> cntCampUser(String pid) {
        return this.mediaCtx.select((SelectField)UserAiRepository.UAP.OPEN_TIME, (SelectField)DSL.count()).from((TableLike)UAP).where(new Condition[]{UserAiRepository.UAP.PID.eq((Object)pid)}).groupBy(new GroupField[]{UserAiRepository.UAP.OPEN_TIME}).fetchMap((Field)UserAiRepository.UAP.OPEN_TIME, (Field)DSL.count());
    }

    public int cntUserByCamp(String pid, long openTime) {
        return this.mediaCtx.fetchCount((Table)UAP, UserAiRepository.UAP.PID.eq((Object)pid).and(UserAiRepository.UAP.OPEN_TIME.eq((Object)openTime)));
    }

    public List<String> getCampSuids(String pid, Long openTime) {
        return this.mediaCtx.select((SelectField)UserAiRepository.UAP.SUID).from((TableLike)UAP).where(new Condition[]{UserAiRepository.UAP.PID.eq((Object)pid).and(UserAiRepository.UAP.OPEN_TIME.eq((Object)openTime))}).fetchInto(String.class);
    }

    public List<UserAiHomework> getLessonHomeworksWithPic(String pid, String aid, Collection<String> suids, Collection<String> materialIds, int start, int size) {
        return this.mediaCtx.selectFrom((Table)UAH).where(new Condition[]{UserAiRepository.UAH.PID.eq((Object)pid).and(UserAiRepository.UAH.AID.eq((Object)aid)).and(UserAiRepository.UAH.SUID.in(suids)).and(UserAiRepository.UAH.MATERIAL_ID.in(materialIds)).and(UserAiRepository.UAH.PIC.isNotNull())}).orderBy(UserAiRepository.UAH.LIKE_CNT.desc(), UserAiRepository.UAH.CREATE_TIME.asc()).limit(start, size).fetchInto(UserAiHomework.class);
    }

    public UserAiHomework getHomework(String hid) {
        return (UserAiHomework)this.mediaCtx.selectFrom((Table)UAH).where(new Condition[]{UserAiRepository.UAH.HID.eq((Object)hid)}).fetchAnyInto(UserAiHomework.class);
    }

    public boolean existForIdAndUid(String hid, String suid) {
        return this.mediaCtx.fetchExists((Table)AHL, UserAiRepository.AHL.HID.eq((Object)hid).and(UserAiRepository.AHL.SUID.eq((Object)suid)));
    }

    public void addHomeworkLike(String hid, String suid) {
        this.mediaCtx.insertInto((Table)AHL, (Field)UserAiRepository.AHL.HID, (Field)UserAiRepository.AHL.SUID, (Field)UserAiRepository.AHL.CREATE_TIME).values((Object)hid, (Object)suid, (Object)System.currentTimeMillis()).onDuplicateKeyIgnore().execute();
    }

    public void deleteHomeworkLike(String hid, String suid) {
        this.mediaCtx.deleteFrom((Table)AHL).where(new Condition[]{UserAiRepository.AHL.HID.eq((Object)hid).and(UserAiRepository.AHL.SUID.eq((Object)suid))}).execute();
    }

    public void addLikeCnt(String hid, int cnt) {
        this.mediaCtx.update((Table)UAH).set((Field)UserAiRepository.UAH.LIKE_CNT, UserAiRepository.UAH.LIKE_CNT.add((Number)cnt)).where(new Condition[]{UserAiRepository.UAH.HID.eq((Object)hid)}).execute();
    }

    public int cntLessonHomeworksWithPic(String pid, String aid, Collection<String> suids) {
        return this.mediaCtx.fetchCount((Table)UAH, UserAiRepository.UAH.PID.eq((Object)pid).and(UserAiRepository.UAH.AID.eq((Object)aid)).and(UserAiRepository.UAH.SUID.in(suids)).and(UserAiRepository.UAH.PIC.isNotNull()));
    }

    public UserAiHomework getHomeWork(String suid, String pid, String aid, String sectionId, String materialId) {
        return (UserAiHomework)this.mediaCtx.selectFrom((Table)UAH).where(new Condition[]{UserAiRepository.UAH.SUID.eq((Object)suid).and(UserAiRepository.UAH.PID.eq((Object)pid)).and(UserAiRepository.UAH.AID.eq((Object)aid)).and(UserAiRepository.UAH.SECTION_ID.eq((Object)sectionId)).and(UserAiRepository.UAH.MATERIAL_ID.eq((Object)materialId))}).fetchAnyInto(UserAiHomework.class);
    }

    public void saveHomework(UserAiHomeworkRecord hRecord) {
        this.mediaCtx.insertInto((Table)UAH).set((Record)hRecord).onDuplicateKeyUpdate().set((Record)hRecord).execute();
    }

    public UserAiHomework getFirstPicAudioHomework(String suid, String pid, String aid) {
        return (UserAiHomework)this.mediaCtx.selectFrom((Table)UAH).where(new Condition[]{UserAiRepository.UAH.SUID.eq((Object)suid).and(UserAiRepository.UAH.PID.eq((Object)pid)).and(UserAiRepository.UAH.AID.eq((Object)aid)).and(UserAiRepository.UAH.PIC.isNotNull()).and(UserAiRepository.UAH.AUDIO.isNotNull())}).orderBy(UserAiRepository.UAH.CREATE_TIME.asc()).limit(1).fetchAnyInto(UserAiHomework.class);
    }

    public List<String> getUserLearnLessons(String suid, String pid) {
        return this.mediaCtx.select((SelectField)UserAiRepository.UAL.AID).from((TableLike)UAL).where(new Condition[]{UserAiRepository.UAL.SUID.eq((Object)suid).and(UserAiRepository.UAL.PID.eq((Object)pid))}).fetchInto(String.class);
    }

    public Integer cntUserPackPics(String suid, String pid) {
        return this.mediaCtx.fetchCount((Table)UAH, UserAiRepository.UAH.SUID.eq((Object)suid).and(UserAiRepository.UAH.PID.eq((Object)pid)).and(UserAiRepository.UAH.PIC.isNotNull()));
    }

    public List<String> mutiGetLikedHids(String suid, Collection<String> hids) {
        return this.mediaCtx.select((SelectField)UserAiRepository.AHL.HID).from((TableLike)AHL).where(new Condition[]{UserAiRepository.AHL.SUID.eq((Object)suid).and(UserAiRepository.AHL.HID.in(hids))}).fetchInto(String.class);
    }

    public int cntABCLessonHaveWorksSuids(String pid, String aid, Collection<String> suids) {
        return this.mediaCtx.fetchCount((Table)UAL, UserAiRepository.UAL.SUID.in(suids).and(UserAiRepository.UAL.PID.eq((Object)pid)).and(UserAiRepository.UAL.AID.eq((Object)aid)).and(UserAiRepository.UAL.HAVE_WORKS.eq((Object)1)));
    }

    public void recordUserAiDayLearn(String day, String suid, Integer learnTime) {
        this.mediaCtx.insertInto((Table)UADL).set((Field)UserAiRepository.UADL.DAY, (Object)day).set((Field)UserAiRepository.UADL.SUID, (Object)suid).set((Field)UserAiRepository.UADL.LEARN_TIME, (Object)learnTime).onDuplicateKeyUpdate().set((Field)UserAiRepository.UADL.LEARN_TIME, UserAiRepository.UADL.LEARN_TIME.add((Number)learnTime)).execute();
    }

    public com.jz.jooq.media.tables.pojos.UserAiDayLearn getUserAiDayLearn(String day, String suid) {
        return (com.jz.jooq.media.tables.pojos.UserAiDayLearn)this.mediaCtx.selectFrom((Table)UADL).where(new Condition[]{UserAiRepository.UADL.DAY.eq((Object)day).and(UserAiRepository.UADL.SUID.eq((Object)suid))}).fetchAnyInto(com.jz.jooq.media.tables.pojos.UserAiDayLearn.class);
    }

    public boolean existForABCLike(String suid, String pid, String aid, String likedSuid) {
        return this.mediaCtx.fetchExists((Table)AALL, UserAiRepository.AALL.SUID.eq((Object)suid).and(UserAiRepository.AALL.PID.eq((Object)pid)).and(UserAiRepository.AALL.AID.eq((Object)aid)).and(UserAiRepository.AALL.LIKED_SUID.eq((Object)likedSuid)));
    }

    public Map<String, Integer> getABCLessonHaveWorksSuids(String pid, String aid, Collection<String> suids, int start, int size) {
        return this.mediaCtx.select((SelectField)UserAiRepository.UAL.SUID, (SelectField)UserAiRepository.UAL.LIKE_CNT).from((TableLike)UAL).where(new Condition[]{UserAiRepository.UAL.SUID.in(suids).and(UserAiRepository.UAL.PID.eq((Object)pid)).and(UserAiRepository.UAL.AID.eq((Object)aid)).and(UserAiRepository.UAL.HAVE_WORKS.eq((Object)1))}).orderBy(UserAiRepository.UAL.LIKE_CNT.desc()).limit(start, size).fetchMap((Field)UserAiRepository.UAL.SUID, (Field)UserAiRepository.UAL.LIKE_CNT);
    }

    public List<UserAiHomework> getLessonHomeworks(String pid, String aid, Collection<String> suids, Collection<String> materialIds) {
        return this.mediaCtx.selectFrom((Table)UAH).where(new Condition[]{UserAiRepository.UAH.PID.eq((Object)pid).and(UserAiRepository.UAH.AID.eq((Object)aid)).and(UserAiRepository.UAH.SUID.in(suids)).and(UserAiRepository.UAH.MATERIAL_ID.in(materialIds))}).orderBy(UserAiRepository.UAH.CREATE_TIME.asc()).fetchInto(UserAiHomework.class);
    }

    public List<String> mutiGetLikedABCSuids(String suid, String pid, String aid) {
        return this.mediaCtx.select((SelectField)UserAiRepository.AALL.SUID).from((TableLike)AALL).where(new Condition[]{UserAiRepository.AALL.PID.eq((Object)pid).and(UserAiRepository.AALL.AID.eq((Object)aid)).and(UserAiRepository.AALL.LIKED_SUID.eq((Object)suid))}).fetchInto(String.class);
    }

    public void addABCLessonLike(String likeSuid, String pid, String aid, String suid) {
        this.mediaCtx.insertInto((Table)AALL, (Field)UserAiRepository.AALL.SUID, (Field)UserAiRepository.AALL.PID, (Field)UserAiRepository.AALL.AID, (Field)UserAiRepository.AALL.LIKED_SUID, (Field)UserAiRepository.AALL.CREATE_TIME).values((Object)likeSuid, (Object)pid, (Object)aid, (Object)suid, (Object)System.currentTimeMillis()).onDuplicateKeyIgnore().execute();
    }

    public void deleteABCLessonLike(String likeSuid, String pid, String aid, String suid) {
        this.mediaCtx.deleteFrom((Table)AALL).where(new Condition[]{UserAiRepository.AALL.SUID.eq((Object)likeSuid).and(UserAiRepository.AALL.PID.eq((Object)pid)).and(UserAiRepository.AALL.AID.eq((Object)aid)).and(UserAiRepository.AALL.LIKED_SUID.eq((Object)suid))}).execute();
    }

    public void addABCLessonLikeCnt(String suid, String pid, String aid, int cnt) {
        this.mediaCtx.update((Table)UAL).set((Field)UserAiRepository.UAL.LIKE_CNT, UserAiRepository.UAL.LIKE_CNT.add((Number)cnt)).where(new Condition[]{UserAiRepository.UAL.SUID.eq((Object)suid).and(UserAiRepository.UAL.PID.eq((Object)pid)).and(UserAiRepository.UAL.AID.eq((Object)aid))}).execute();
    }

    public void updateLessonHaveWorks(String suid, String pid, String aid) {
        this.mediaCtx.update((Table)UAL).set((Field)UserAiRepository.UAL.HAVE_WORKS, (Object)1).where(new Condition[]{UserAiRepository.UAL.SUID.eq((Object)suid).and(UserAiRepository.UAL.PID.eq((Object)pid)).and(UserAiRepository.UAL.AID.eq((Object)aid))}).execute();
    }

    public void recordUserAiDayWords(String day, String suid, String materialId) {
        this.mediaCtx.insertInto((Table)UADW).set((Field)UserAiRepository.UADW.DAY, (Object)day).set((Field)UserAiRepository.UADW.SUID, (Object)suid).set((Field)UserAiRepository.UADW.MATERIAL_ID, (Object)materialId).onDuplicateKeyIgnore().execute();
    }

    public int getUserAiDayWords(String day, String suid) {
        return this.mediaCtx.fetchCount((Table)UADW, UserAiRepository.UADW.DAY.eq((Object)day).and(UserAiRepository.UADW.SUID.eq((Object)suid)));
    }
}

