/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.repository;

import com.jz.jar.media.enums.DbField;
import com.jz.jar.media.repository.MediaBaseRepository;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.TomatoTagCoursePlaylist;
import com.jz.jooq.media.tables.TomatoTagInfo;
import java.util.Collection;
import java.util.List;
import org.jooq.Condition;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class TomatoTagRepository
extends MediaBaseRepository {
    private static final TomatoTagInfo TTI = Tables.TOMATO_TAG_INFO;
    private static final TomatoTagCoursePlaylist TTCP = Tables.TOMATO_TAG_COURSE_PLAYLIST;

    public List<com.jz.jooq.media.tables.pojos.TomatoTagInfo> listTags(String brand) {
        return this.mediaCtx.select((SelectField)TomatoTagRepository.TTI.ID, (SelectField)TomatoTagRepository.TTI.NAME).from((TableLike)TTI).where(new Condition[]{TomatoTagRepository.TTI.BRAND.eq((Object)brand)}).orderBy(TomatoTagRepository.TTI.SEQ.asc()).fetchInto(com.jz.jooq.media.tables.pojos.TomatoTagInfo.class);
    }

    public com.jz.jooq.media.tables.pojos.TomatoTagInfo getTag(String brand, String tid) {
        return (com.jz.jooq.media.tables.pojos.TomatoTagInfo)this.mediaCtx.select((SelectField)TomatoTagRepository.TTI.ID, (SelectField)TomatoTagRepository.TTI.NAME).from((TableLike)TTI).where(new Condition[]{TomatoTagRepository.TTI.BRAND.eq((Object)brand).and(TomatoTagRepository.TTI.ID.eq((Object)tid))}).fetchAnyInto(com.jz.jooq.media.tables.pojos.TomatoTagInfo.class);
    }

    public List<com.jz.jooq.media.tables.pojos.TomatoTagInfo> mutiGetTags(String brand, Collection<String> tids) {
        return this.mediaCtx.select((SelectField)TomatoTagRepository.TTI.ID, (SelectField)TomatoTagRepository.TTI.NAME).from((TableLike)TTI).where(new Condition[]{TomatoTagRepository.TTI.BRAND.eq((Object)brand).and(TomatoTagRepository.TTI.ID.in(tids))}).fetchInto(com.jz.jooq.media.tables.pojos.TomatoTagInfo.class);
    }

    public int cntOnlineOnSalePCsPage(String brand, String tid) {
        return this.mediaCtx.fetchCount((Table)TTCP, TomatoTagRepository.TTCP.BRAND.eq((Object)brand).and(TomatoTagRepository.TTCP.TID.eq((Object)tid)).and(TomatoTagRepository.TTCP.STATUS.eq((Object)DbField.online.name())).and(TomatoTagRepository.TTCP.SALE_STATUS.eq((Object)1)));
    }

    public List<com.jz.jooq.media.tables.pojos.TomatoTagCoursePlaylist> getOnlineOnSalePCsPage(String brand, String tid, int start, int size) {
        return this.mediaCtx.select((SelectField)TomatoTagRepository.TTCP.PID, (SelectField)TomatoTagRepository.TTCP.TYPE).from((TableLike)TTCP).where(new Condition[]{TomatoTagRepository.TTCP.BRAND.eq((Object)brand).and(TomatoTagRepository.TTCP.TID.eq((Object)tid)).and(TomatoTagRepository.TTCP.STATUS.eq((Object)DbField.online.name())).and(TomatoTagRepository.TTCP.SALE_STATUS.eq((Object)1))}).orderBy(TomatoTagRepository.TTCP.SEQ.desc()).limit(start, size).fetchInto(com.jz.jooq.media.tables.pojos.TomatoTagCoursePlaylist.class);
    }
}

