/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.service;

import com.google.common.collect.Lists;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.media.repository.AiRepository;
import com.jz.jar.media.service.UserAiService;
import com.jz.jar.media.wrapper.AiPackCampWrapper;
import com.jz.jooq.media.tables.pojos.AiLesson;
import com.jz.jooq.media.tables.pojos.AiLessonSection;
import com.jz.jooq.media.tables.pojos.AiLessonSectionMaterial;
import com.jz.jooq.media.tables.pojos.AiMaterial;
import com.jz.jooq.media.tables.pojos.AiPackCamp;
import com.jz.jooq.media.tables.pojos.AiPackSerie;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class AiService {
    @Autowired
    private AiRepository aiRepository;
    @Autowired
    private UserAiService userAiService;

    public AiLesson getLesson(String aid) {
        return this.aiRepository.getLesson(aid);
    }

    public List<AiLesson> mutiGetOnlineLesson(Collection<String> aids) {
        return this.aiRepository.mutiGetOnlineLesson(aids);
    }

    public List<AiLessonSection> getAiSections(String aid) {
        return this.aiRepository.getAiSections(aid);
    }

    public List<String> getAiSectionIds(String aid) {
        return this.aiRepository.getAiSectionIds(aid);
    }

    public List<AiLessonSectionMaterial> getAiMaterials(String aid) {
        return this.aiRepository.getAiMaterials(aid);
    }

    public List<String> getAiMaterialIdsInSection(String aid, String sectionId) {
        return this.aiRepository.getAiMaterialIdsInSection(aid, sectionId);
    }

    public AiMaterial getMaterial(String id) {
        return this.aiRepository.getMaterial(id);
    }

    public List<AiMaterial> mutiGetOnlineMaterials(Collection<String> ids) {
        return this.aiRepository.mutiGetOnlineMaterials(ids);
    }

    public List<AiPackSerie> getSeries(String pid) {
        return this.aiRepository.getSeries(pid);
    }

    public List<AiPackCampWrapper> getJoinAbleCampsTimeName(String pid, boolean isAll, int size) {
        List<AiPackCamp> camps = this.aiRepository.getJoinAbleCampsTimeName(pid);
        if (ArrayMapTools.isEmpty(camps)) {
            return null;
        }
        Map<Long, Integer> campUser = this.userAiService.cntCampUser(pid);
        ArrayList list = Lists.newArrayList();
        for (AiPackCamp c : camps) {
            AiPackCampWrapper w = AiPackCampWrapper.of(c);
            if (campUser.containsKey(c.getOpenTime())) {
                if (!isAll && c.getMaxNum() <= campUser.get(c.getOpenTime())) continue;
                w.setLeftNum(c.getMaxNum() - campUser.get(c.getOpenTime()));
            } else {
                w.setLeftNum(c.getMaxNum());
            }
            list.add(w);
        }
        return list.subList(0, Math.min(list.size(), size));
    }

    public Long getRecentJoinAbleCamp(String pid) {
        return this.aiRepository.getRecentJoinAbleCamp(pid);
    }

    public AiPackCamp getCamp(String pid, long openTime) {
        return this.aiRepository.getCamp(pid, openTime);
    }

    public Map<Integer, Long> getCampLessonTimeMap(String pid, long openTime) {
        return this.aiRepository.getCampLessonTimeMap(pid, openTime);
    }

    public Long getLessonTime(String pid, Long openTime, int seq) {
        return this.aiRepository.getLessonTime(pid, openTime, seq);
    }

    public AiPackSerie getserie(String pid, String serieId) {
        return this.aiRepository.getSerie(pid, serieId);
    }

    public List<String> filterPicAudioMaterialIds(Collection<String> materialIds) {
        return this.aiRepository.filterPicAudioMaterialIds(materialIds);
    }
}

