/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.enums;

import com.google.common.collect.Maps;
import java.util.Map;

public enum AuditStatus {
    unchanged("\u672a\u6539\u53d8", -100),
    finished("\u5df2\u5b8c\u6210", -50),
    reset("\u91cd\u7f6e", 0),
    online("\u5df2\u4e0a\u7ebf", 1),
    offline("\u5df2\u4e0b\u7ebf", 10),
    verify("\u5ba1\u6838\u4e2d", 30),
    notPassed("\u5ba1\u6838\u672a\u901a\u8fc7", 40),
    delete("\u7528\u6237\u5220\u9664", 98),
    adminDelete("\u7ba1\u7406\u5458\u5220\u9664", 99);

    private int code;
    private static Map<Integer, AuditStatus> code2Status;

    private AuditStatus(String desc, int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static AuditStatus ofCode(int code) {
        if (!code2Status.isEmpty()) {
            return code2Status.get(code);
        }
        for (AuditStatus temp : AuditStatus.values()) {
            code2Status.put(temp.code, temp);
        }
        return code2Status.get(code);
    }

    static {
        code2Status = Maps.newHashMap();
    }
}

