package com.jz.jar.media.service;

import java.util.Collection;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.media.repository.TomatoTagRepository;
import com.jz.jooq.media.tables.pojos.TomatoTagCoursePlaylist;
import com.jz.jooq.media.tables.pojos.TomatoTagInfo;

@Lazy
@Service
public class TomatoTagService {

	@Autowired
	private TomatoTagRepository tomatoTagRepository;

	public List<TomatoTagInfo> listTags(String brand) {
		return tomatoTagRepository.listTags(brand);
	}

	public TomatoTagInfo getTag(String brand, String tid) {
		return tomatoTagRepository.getTag(brand, tid);
	}

	public List<TomatoTagInfo> mutiGetTags(String brand, Collection<String> tids) {
		return tomatoTagRepository.mutiGetTags(brand, tids);
	}

	public int cntOnlineOnSalePCsPage(String brand, String tid) {
		return tomatoTagRepository.cntOnlineOnSalePCsPage(brand, tid);
	}

	public List<TomatoTagCoursePlaylist> getOnlineOnSalePCsPage(String brand, String tid, int start, int size) {
		return tomatoTagRepository.getOnlineOnSalePCsPage(brand, tid, start, size);
	}
}
