/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.service;

import com.jz.jar.media.repository.UserCourseOrderRepository;
import com.jz.jooq.media.tables.pojos.UserCourseOrder;
import com.jz.jooq.media.tables.records.UserCourseOrderRecord;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class UserCourseOrderService {
    @Autowired
    private UserCourseOrderRepository userCourseOrderRepository;

    public boolean checkPayed(String uid, String brand, String pid) {
        if (StringUtils.isEmpty((CharSequence)uid)) {
            return false;
        }
        return this.userCourseOrderRepository.checkPayed(uid, brand, pid);
    }

    public UserCourseOrder getPayedOrder(String uid, String brand, String pid) {
        return this.userCourseOrderRepository.getPayedOrder(uid, brand, pid);
    }

    public void buyByCoinFinish(String orderId, String uid, String brand, String pid, Integer coin) {
        long current = System.currentTimeMillis();
        UserCourseOrderRecord record = new UserCourseOrderRecord();
        record.setOrderId(orderId);
        record.setUid(uid);
        record.setBrand(brand);
        record.setPid(pid);
        record.setType("coin");
        record.setCoin(coin);
        record.setPayTime(Long.valueOf(current));
        record.setEndTime(Long.valueOf(current + 31104000000L));
        record.setStatus(Integer.valueOf(1));
        record.setCreateTime(Long.valueOf(current));
        this.userCourseOrderRepository.createOrder(record);
    }

    public void buyByTaskFinish(String orderId, String uid, String brand, String pid, String type) {
        long current = System.currentTimeMillis();
        UserCourseOrderRecord record = new UserCourseOrderRecord();
        record.setOrderId(orderId);
        record.setUid(uid);
        record.setBrand(brand);
        record.setPid(pid);
        record.setType(type);
        record.setPayTime(Long.valueOf(current));
        record.setEndTime(Long.valueOf(current + 31104000000L));
        record.setStatus(Integer.valueOf(1));
        record.setCreateTime(Long.valueOf(current));
        this.userCourseOrderRepository.createOrder(record);
    }

    public void buyByMoneyCreate(String orderId, String uid, String brand, String pid, BigDecimal money) {
        long current = System.currentTimeMillis();
        UserCourseOrderRecord record = new UserCourseOrderRecord();
        record.setOrderId(orderId);
        record.setUid(uid);
        record.setBrand(brand);
        record.setPid(pid);
        record.setType("money");
        record.setNeedPayMoney(money);
        record.setEndTime(Long.valueOf(current + 31104000000L));
        record.setStatus(Integer.valueOf(0));
        record.setCreateTime(Long.valueOf(current));
        this.userCourseOrderRepository.createOrder(record);
    }

    public UserCourseOrder getOrder(String orderId) {
        return this.userCourseOrderRepository.getOrder(orderId);
    }

    public void finishPay(String orderId, BigDecimal payMoney, String paymentMode, String onlineTradeId) {
        this.userCourseOrderRepository.finishPay(orderId, payMoney, paymentMode, onlineTradeId);
    }
}

