/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.service;

import com.jz.jar.media.repository.UserAiRepository;
import com.jz.jooq.media.tables.pojos.UserAiHomework;
import com.jz.jooq.media.tables.pojos.UserAiLesson;
import com.jz.jooq.media.tables.pojos.UserAiLessonSection;
import com.jz.jooq.media.tables.pojos.UserAiPack;
import com.jz.jooq.media.tables.records.UserAiHomeworkRecord;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Lazy
@Service
public class UserAiService {
    @Autowired
    private UserAiRepository userAiRepository;

    public List<UserAiHomework> getHomeworks(String suid, String pid, String aid) {
        return this.userAiRepository.getHomeworks(suid, pid, aid);
    }

    public List<UserAiHomework> mutiGetHomework(String suid, String pid, String aid, Collection<String> materialIds) {
        return this.userAiRepository.mutiGetHomework(suid, pid, aid, materialIds);
    }

    public void savePack(String uid, String suid, String pid, long openTime) {
        this.userAiRepository.savePack(uid, suid, pid, openTime);
    }

    public UserAiPack getPack(String uid, String pid) {
        return this.userAiRepository.getPack(uid, pid);
    }

    public void saveLesson(String suid, String pid, String aid, int status, String currentSectionId, String currentMaterialId, Long finishTime) {
        this.userAiRepository.saveLesson(suid, pid, aid, status, currentSectionId, currentMaterialId, finishTime);
    }

    public Map<String, Integer> mutiCalFinishNum(String suid, Collection<String> pids) {
        return this.userAiRepository.mutiCalFinishNum(suid, pids);
    }

    public List<UserAiLesson> getLessons(String suid, String pid) {
        return this.userAiRepository.getLessons(suid, pid);
    }

    public UserAiLesson getLesson(String suid, String pid, String aid) {
        return this.userAiRepository.getLesson(suid, pid, aid);
    }

    public void saveSection(String suid, String pid, String aid, String sectionId, int status, String currentMaterialId) {
        this.userAiRepository.saveSection(suid, pid, aid, sectionId, status, currentMaterialId);
    }

    public List<UserAiLessonSection> getSections(String suid, String pid, String aid) {
        return this.userAiRepository.getSections(suid, pid, aid);
    }

    public UserAiLessonSection getSection(String suid, String pid, String aid, String sectionId) {
        return this.userAiRepository.getSection(suid, pid, aid, sectionId);
    }

    public Map<Long, Integer> cntCampUser(String pid) {
        return this.userAiRepository.cntCampUser(pid);
    }

    public int cntUserByCamp(String pid, long openTime) {
        return this.userAiRepository.cntUserByCamp(pid, openTime);
    }

    public List<String> getCampSuids(String pid, Long openTime) {
        return this.userAiRepository.getCampSuids(pid, openTime);
    }

    public List<UserAiHomework> getLessonHomeworks(String pid, String aid, Collection<String> suids, int start, int size) {
        return this.userAiRepository.getLessonHomeworks(pid, aid, suids, start, size);
    }

    public UserAiHomework getHomework(String hid) {
        return this.userAiRepository.getHomework(hid);
    }

    public boolean existForIdAndUid(String hid, String suid) {
        return this.userAiRepository.existForIdAndUid(hid, suid);
    }

    @Transactional
    public void updateHomeworkLike(String hid, String suid, boolean isLike) {
        if (isLike) {
            this.userAiRepository.addHomeworkLike(hid, suid);
        } else {
            this.userAiRepository.deleteHomeworkLike(hid, suid);
        }
        this.userAiRepository.addLikeCnt(hid, isLike ? 1 : -1);
    }

    public int cntLessonHomeworksWithPic(String pid, String aid, Collection<String> suids) {
        return this.userAiRepository.cntLessonHomeworksWithPic(pid, aid, suids);
    }

    public UserAiHomework getHomeWork(String suid, String pid, String aid, String sectionId, String materialId) {
        return this.userAiRepository.getHomeWork(suid, pid, aid, sectionId, materialId);
    }

    public void saveHomework(UserAiHomeworkRecord hRecord) {
        this.userAiRepository.saveHomework(hRecord);
    }

    public UserAiHomework getFirstHomeworkPic(String suid, String pid, String aid) {
        return this.userAiRepository.getFirstHomeworkPic(suid, pid, aid);
    }

    public List<String> getUserLearnLessons(String suid, String pid) {
        return this.userAiRepository.getUserLearnLessons(suid, pid);
    }

    public Integer cntUserPackPics(String suid, String pid) {
        return this.userAiRepository.cntUserPackPics(suid, pid);
    }

    public List<String> mutiGetLikedHids(String suid, Collection<String> hids) {
        return this.userAiRepository.mutiGetLikedHids(suid, hids);
    }
}

