package com.jz.jar.media.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.media.repository.UserSignTaskRepository;
import com.jz.jooq.media.tables.pojos.UserSignDaySetting;
import com.jz.jooq.media.tables.pojos.UserSignMonthSetting;

@Lazy
@Service
public class UserSignTaskService {

	@Autowired
	private UserSignTaskRepository userSignTaskRepository;

	public List<UserSignDaySetting> getDaySettings(String brand, String month) {
		return userSignTaskRepository.getDaySettings(brand, month);
	}

	public UserSignDaySetting getDaySetting(String brand, String date) {
		return userSignTaskRepository.getDaySetting(brand, date);
	}

	public List<UserSignMonthSetting> getAccuSettings(String brand, String month) {
		return userSignTaskRepository.getAccuSettings(brand, month);
	}

	public UserSignMonthSetting getAccuSetting(String brand, String month, int days) {
		return userSignTaskRepository.getAccuSetting(brand, month, days);
	}
}
