package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.TomatoCourseAi;
import com.jz.jooq.media.tables.pojos.TomatoCourseAiPart;
import com.jz.jooq.media.tables.pojos.TomatoCourseAiPartVideo;
import com.jz.jooq.media.tables.pojos.TomatoCourseAiTeacher;

@Lazy
@Repository
public class TomatoCourseAiRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.TomatoCourseAi TCA = Tables.TOMATO_COURSE_AI;
	private static final com.jz.jooq.media.tables.TomatoCourseAiTeacher TCAT = Tables.TOMATO_COURSE_AI_TEACHER;
	private static final com.jz.jooq.media.tables.TomatoCourseAiPart TCAP = Tables.TOMATO_COURSE_AI_PART;
	private static final com.jz.jooq.media.tables.TomatoCourseAiPartVideo TCAPV = Tables.TOMATO_COURSE_AI_PART_VIDEO;

	public TomatoCourseAi getAi(String aid) {
		return mediaCtx.selectFrom(TCA).where(TCA.AID.eq(aid).and(TCA.STATUS.eq(1))).fetchAnyInto(TomatoCourseAi.class);
	}

	public List<TomatoCourseAi> mutiGetOnlineAi(Collection<String> aids) {
		return mediaCtx.selectFrom(TCA).where(TCA.AID.in(aids).and(TCA.STATUS.eq(1))).fetchInto(TomatoCourseAi.class);
	}

	public List<TomatoCourseAiTeacher> getTeacherVideosByAid(String aid) {
		return mediaCtx.selectFrom(TCAT).where(TCAT.AID.eq(aid).and(TCAT.STATUS.eq(1)))
				.orderBy(TCAT.CREATE_TIME.desc()).fetchInto(TomatoCourseAiTeacher.class);
	}

	public List<TomatoCourseAiPart> getPartsByAid(String aid) {
		return mediaCtx.selectFrom(TCAP).where(TCAP.AID.eq(aid).and(TCAP.STATUS.eq(1))).orderBy(TCAP.SEQ.asc())
				.fetchInto(TomatoCourseAiPart.class);
	}

	public List<TomatoCourseAiPartVideo> getVideosByPartId(String partId) {
		return mediaCtx.selectFrom(TCAPV).where(TCAPV.PART_ID.eq(partId).and(TCAPV.STATUS.eq(1)))
				.orderBy(TCAPV.WEIGHT.desc(), TCAPV.CREATE_TIME.asc()).fetchInto(TomatoCourseAiPartVideo.class);
	}

}
