package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.QuestionOption;

@Lazy
@Repository
public class QuestionOptionRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.QuestionOption QO = Tables.QUESTION_OPTION;

	public Map<String, String> getQuestionRightOption(Collection<String> qids) {
		List<QuestionOption> options = mediaCtx.select(QO.QID, QO.OID).from(QO)
				.where(QO.QID.in(qids).and(QO.IS_RIGHT.eq(1))).fetchInto(QuestionOption.class);
		if (ArrayMapTools.isEmpty(options)) {
			return Maps.newHashMap();
		}
		return options.stream().collect(Collectors.toMap(it -> it.getQid(), it -> it.getOid()));
	}

	public List<QuestionOption> getQuestionOptions(Collection<String> qids) {
		return mediaCtx.selectFrom(QO).where(QO.QID.in(qids)).fetchInto(QuestionOption.class);
	}
}
