/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.service;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.media.cache.PlaylistRecommCache;
import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.repository.PlaylistRepository;
import com.jz.jooq.media.tables.pojos.Playlist;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class PlaylistService {
    @Autowired
    private PlaylistRepository playlistRepository;
    @Autowired
    private PlaylistRecommCache playlistRecommCache;

    public Playlist getOnlinePlaylist(String pid, BrandEnum brand) {
        return this.playlistRepository.getOnlinePlaylist(pid, brand);
    }

    public List<Playlist> getOnlinePlaylist(Collection<String> pids, BrandEnum brand) {
        return this.playlistRepository.getOnlinePlaylist(pids, brand);
    }

    public Map<String, Integer> getPlaylistToVideoCount(Collection<String> pids) {
        return this.playlistRepository.getPlaylistToVideoCount(pids);
    }

    public String getWidForPlaylist(String pid) {
        return this.playlistRepository.getWidForPlaylist(pid);
    }

    public void addWatchCnt(String pid, BrandEnum brand, int cnt) {
        this.playlistRepository.addWatchCnt(pid, brand, cnt);
    }

    public List<String> findOnlinePlaylistId(BrandEnum brand, int size) {
        List<String> pids = this.playlistRecommCache.getPlaylistIds(brand);
        if (ArrayMapTools.isNotEmpty(pids)) {
            return pids;
        }
        pids = this.playlistRepository.findOnlinePlaylistId(brand, size);
        this.playlistRecommCache.setPlaylistIds(brand, pids);
        return pids;
    }
}

