package com.jz.jar.media.service;

import java.util.Collection;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.repository.WorksInfoRepository;
import com.jz.jooq.media.tables.pojos.WorksInfo;

@Lazy
@Service
public class WorksInfoService {

	@Autowired
	private WorksInfoRepository worksInfoRepository;

	public boolean isExistWorksInfo(String id, BrandEnum brand) {
		return worksInfoRepository.isExistWorksInfo(id, brand);
	}

	public WorksInfo getWorksInfo(String id, BrandEnum brand) {
		return worksInfoRepository.getWorksInfo(id, brand);
	}

	public WorksInfo getSimpleWorksInfo(String id, BrandEnum brand) {
		return worksInfoRepository.getSimpleWorksInfo(id, brand);
	}

	public List<WorksInfo> findSimpleWorksInfo(Collection<String> artIds) {
		return worksInfoRepository.findSimpleWorksInfo(artIds);
	}

	public void updateOpenInfo(String id, BrandEnum brand, int isOpen, int addLikeCnt) {
		worksInfoRepository.updateOpenInfo(id, brand, isOpen, addLikeCnt);
	}

	public int countOpenNewWorks(BrandEnum brand, Collection<String> workIds, long timestamp) {
		return worksInfoRepository.countOpenNewWorks(brand, workIds, timestamp);
	}

	public int countRecommonWorks(BrandEnum brand) {
		return worksInfoRepository.countRecommonWorks(brand);
	}

	public List<String> findRecommonWorksId(BrandEnum brand, int start, int size) {
		return worksInfoRepository.findRecommonWorksId(brand, start, size);
	}

	public int countOpenWorksForTopic(BrandEnum brand, String topicId) {
		return worksInfoRepository.countOpenWorksForTopic(brand, topicId);
	}

	public List<String> getOpenWorkIdsForTopic(BrandEnum brand, String tid, boolean isHot, int start, int size) {
		return worksInfoRepository.getOpenWorkIdsForTopic(brand, tid, isHot, start, size);
	}

	public void addLikeCnt(String id, BrandEnum brand, int addLikeCnt) {
		worksInfoRepository.addLikeCnt(id, brand, addLikeCnt);
	}

	public List<String> filterOpenWorkIds(BrandEnum brand, Collection<String> wids, boolean isHot, int start, int size) {
		return worksInfoRepository.filterOpenWorkIds(brand, wids, isHot, start, size);
	}

	public int countFilterOpenWorkIds(BrandEnum brand, Collection<String> wids) {
		return worksInfoRepository.countFilterOpenWorkIds(brand, wids);
	}

	public WorksInfo getWorksInfo(String schoolId, String lessonId, String suid) {
		return worksInfoRepository.getWorksInfo(schoolId, lessonId, suid);
	}

	public void createWorkInfo(String id, String brandId, String schoolId, String lessonId, String puid, String suid,
			String title, String appraise, String pic, String pictures, String audio, Integer audioDuration,
			String wid, String material, String tid, int isOpen, int status, String operator, int isCollective,
			int selfUpload) {
		worksInfoRepository.createWorkInfo(id, brandId, schoolId, lessonId, puid, suid, title, appraise, pic, pictures,
				audio, audioDuration, wid, material, tid, isOpen, status, operator, isCollective, selfUpload);
	}

	public void updateWorkInfo(String id, String schoolId, String lessonId, String title, String appraise, String pic,
			String pictures, String audio, Integer audioDuration, String wid, int status, String rejectReason) {
		worksInfoRepository.updateWorkInfo(id, schoolId, lessonId, title, appraise, pic, pictures, audio,
				audioDuration, wid, status, rejectReason);
	}

	public void updateWorkInfoPic(String id, String pic, String pictures) {
		worksInfoRepository.updateWorkInfoPic(id, pic, pictures);
	}
}
