package com.jz.jar.media.service;

import java.util.Collection;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.media.repository.TomatoCourseAiRepository;
import com.jz.jooq.media.tables.pojos.TomatoCourseAi;
import com.jz.jooq.media.tables.pojos.TomatoCourseAiPart;
import com.jz.jooq.media.tables.pojos.TomatoCourseAiPartVideo;
import com.jz.jooq.media.tables.pojos.TomatoCourseAiTeacher;

@Lazy
@Service
public class TomatoCourseAiService {

	@Autowired
	private TomatoCourseAiRepository tomatoCourseAiRepository;

	public TomatoCourseAi getAi(String aid) {
		return tomatoCourseAiRepository.getAi(aid);
	}

	public List<TomatoCourseAi> mutiGetOnlineAi(Collection<String> aids) {
		return tomatoCourseAiRepository.mutiGetOnlineAi(aids);
	}

	public List<TomatoCourseAiTeacher> getTeacherVideosByAid(String aid) {
		return tomatoCourseAiRepository.getTeacherVideosByAid(aid);
	}

	public List<TomatoCourseAiPart> getPartsByAid(String aid) {
		return tomatoCourseAiRepository.getPartsByAid(aid);
	}

	public List<TomatoCourseAiPartVideo> getVideosByPartId(String partId) {
		return tomatoCourseAiRepository.getVideosByPartId(partId);
	}
}
