package com.jz.jar.media.service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.media.repository.SysConfigRepository;
import com.jz.jooq.media.tables.pojos.SysConfig;

@Lazy
@Service
public class SysConfigService {

	@Autowired
	private SysConfigRepository sysConfigRepository;

	public Map<String, String> findAllConfig() {
		List<SysConfig> configs = sysConfigRepository.findAllConfig();
		return configs.stream().collect(Collectors.toMap(it -> it.getName(), it -> it.getVal()));
	}

}
