package com.jz.jar.media.cache;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

import com.jz.common.utils.json.GsonTools;
import com.jz.common.utils.text.StringTools;
import com.jz.jar.media.enums.BrandEnum;
import com.jz.jooq.media.tables.pojos.MediaVideo;

import redis.clients.jedis.JedisCluster;

/**
 * @Title MediaVideoCache
 * @Package com.jz.jar.media.cache
 * @author tangjunfeng
 * @date 2019年1月7日 下午4:16:00
 * @version V1.0
 */
@Lazy
@Component
public class MediaVideoCache {

	private static final Logger logger = LoggerFactory.getLogger(MediaVideoCache.class);
	private static final int expireSeconds = 600;

	@Autowired
	private JedisCluster jedisCluster;

	private String key(String wid, BrandEnum brand) {
		return new StringBuffer().append(brand.name()).append(":mv:").append(wid).toString();
	}

	public void setMediaVideo(MediaVideo video, BrandEnum brand) {
		try {
			jedisCluster.set(key(video.getWid(), brand), GsonTools.gson.toJson(video), "nx", "ex", expireSeconds);
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
		}
	}

	public MediaVideo getMediaVideo(String wid, BrandEnum brand) {
		try {
			String value = jedisCluster.get(key(wid, brand));
			if (StringTools.isEmpty(value))
				return null;
			return GsonTools.gson.fromJson(value, MediaVideo.class);
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			return null;
		}
	}
}
