package com.jz.jar.media.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.media.repository.TomatoCourseWorksRepository;
import com.jz.jooq.media.tables.pojos.TomatoCourseWorks;
import com.jz.jooq.media.tables.pojos.TomatoCourseWorksScore;
import com.jz.jooq.media.tables.pojos.TomatoCourseWorksScoreSetting;

@Lazy
@Service
public class TomatoCourseWorksService {

	@Autowired
	private TomatoCourseWorksRepository tomatoCourseWorksRepository;

	public TomatoCourseWorks getWorksByWidSuid(String wid, String suid) {
		return tomatoCourseWorksRepository.getWorksByWidSuid(wid, suid);
	}

	public List<TomatoCourseWorksScoreSetting> listScoreSettings() {
		return tomatoCourseWorksRepository.listScoreSettings();
	}

	public List<TomatoCourseWorksScore> getWorksScore(String worksId) {
		return tomatoCourseWorksRepository.getWorksScore(worksId);
	}

	public void updatePics(String id, String pics) {
		tomatoCourseWorksRepository.updatePics(id, pics);
	}

	public void createWorks(String id, String wid, String suid, String uid, String pid, String pics) {
		tomatoCourseWorksRepository.createWorks(id, wid, suid, uid, pid, pics);
	}

}
