package com.jz.jar.media.service;

import java.util.Collection;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.jz.jar.media.repository.OxTabPlaylistRepository;
import com.jz.jooq.media.tables.pojos.OxTabPlaylist;

@Lazy
@Service
public class OxTabPlaylistService {

	@Autowired
	private OxTabPlaylistRepository oxTabPlaylistRepository;

	public List<OxTabPlaylist> findOxTabPlaylist() {
		return oxTabPlaylistRepository.findOxTabPlaylist();
	}

	public boolean isOxTabPlaylist(String pid) {
		return oxTabPlaylistRepository.isOxTabPlaylist(pid);
	}

	public List<String> findOxTabPlaylistId(Collection<String> pids) {
		List<String> playlistId = oxTabPlaylistRepository.findOxTabPlaylistId(pids);
		return null == playlistId ? Lists.newArrayList() : playlistId;
	}
}
