package com.jz.jar.media.repository;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jar.media.enums.BrandEnum;
import com.jz.jooq.media.Tables;

@Lazy
@Repository
public class SmsWhiteListRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.SmsWhiteList WL = Tables.SMS_WHITE_LIST;

	public boolean isExistWhiteList(BrandEnum brand, String phone) {
		return mediaCtx.fetchExists(WL, WL.BRANCH_ID.eq(brand.name()).and(WL.PHONE.eq(phone)));
	}

}
