package com.jz.jar.media.repository;

import java.util.List;

import org.jooq.Condition;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.common.utils.text.StringTools;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.PlayabcHome;

@Lazy
@Repository
public class PlayabcHomeRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.PlayabcHome PH = Tables.PLAYABC_HOME;

	public List<PlayabcHome> findPlayabcHomes(String ver) {
		return mediaCtx.selectFrom(PH).where(PH.VER.eq(ver)).orderBy(PH.ID.asc()).fetchInto(PlayabcHome.class);
	}

	public void refreshHomeInfo(String ver, int id, String type, String sid, String pic) {
		mediaCtx.update(PH).set(PH.TYPE, type).set(PH.SID, sid).set(PH.PIC, pic)
				.set(PH.LAST_UPDATE, System.currentTimeMillis()).where(PH.VER.eq(ver).and(PH.ID.eq(id))).execute();
	}

	public boolean isUsing(String type, String sid) {
		Condition condition = PH.TYPE.eq(type);
		if (StringTools.isNotEmptyAndBlank(sid))
			condition = condition.and(PH.SID.eq(sid));
		return mediaCtx.fetchExists(PH, condition);
	}
}
