/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.cache;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.media.enums.BrandEnum;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import redis.clients.jedis.JedisCluster;

@Lazy
@Component
public class PlaylistRecommCache {
    private static final Logger logger = LoggerFactory.getLogger(PlaylistRecommCache.class);
    private static final int expireSeconds = 600;
    @Autowired
    private JedisCluster jedisCluster;

    private String key(BrandEnum brand) {
        return new StringBuffer().append(brand.name()).append(":rcm:pls").toString();
    }

    public void setPlaylistIds(BrandEnum brand, List<String> pids) {
        if (ArrayMapTools.isEmpty(pids)) {
            return;
        }
        try {
            String key = this.key(brand);
            String[] array = new String[]{};
            this.jedisCluster.lpush(key, pids.toArray(array));
            this.jedisCluster.expire(key, 600);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public List<String> getPlaylistIds(BrandEnum brand) {
        try {
            return this.jedisCluster.lrange(this.key(brand), 0L, -1L);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

