package com.jz.jar.media.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jz.jar.media.repository.UserCoinRepository;
import com.jz.jooq.media.tables.pojos.UserCoinChange;

@Lazy
@Service
public class UserCoinService {

	@Autowired
	private UserCoinRepository userCoinRepository;

	public int getUserCurrentCoin(String uid) {
		return userCoinRepository.getUserCurrentCoin(uid);
	}

	@Transactional
	public void updateUserCoin(String uid, int num, String remark) {
		userCoinRepository.updateUserCoin(uid, num);
		userCoinRepository.saveCoinChange(uid, num, remark);
	}

	public int cntChangeRecords(String uid, Integer type) {
		return userCoinRepository.cntChangeRecords(uid, type);
	}

	public List<UserCoinChange> getChangeRecords(String uid, Integer type, int start, int size) {
		return userCoinRepository.getChangeRecords(uid, type, start, size);
	}

}
