package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.google.common.collect.Lists;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.UserCourseVideo;

@Lazy
@Repository
public class UserCourseRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.UserCoursePackWatch UCPW = Tables.USER_COURSE_PACK_WATCH;
	private static final com.jz.jooq.media.tables.UserCourseVideo UCV = Tables.USER_COURSE_VIDEO;

	public boolean existPackWatch(String uid, String pid) {
		return mediaCtx.fetchExists(UCPW, UCPW.UID.eq(uid).and(UCPW.PID.eq(pid)));
	}

	public void createPackWatch(String uid, String pid) {
		mediaCtx.insertInto(UCPW, UCPW.UID, UCPW.PID, UCPW.CREATE_TIME).values(uid, pid, System.currentTimeMillis())
				.onDuplicateKeyIgnore().execute();
	}

	public int cntMyPackPage(String uid) {
		return mediaCtx.fetchCount(UCPW, UCPW.UID.eq(uid));
	}

	public List<String> getMyPackIdsPage(String uid, int start, int size) {
		return mediaCtx.select(UCPW.PID).from(UCPW).where(UCPW.UID.eq(uid)).orderBy(UCPW.CREATE_TIME.desc())
				.limit(start, size).fetchInto(String.class);
	}

	public List<UserCourseVideo> mutiGetUserCourseVideos(String suid, Collection<String> wids) {
		return mediaCtx.selectFrom(UCV).where(UCV.SUID.eq(suid).and(UCV.WID.in(wids))).fetchInto(UserCourseVideo.class);
	}

	public UserCourseVideo getUserCourseVideo(String suid, String wid) {
		return mediaCtx.selectFrom(UCV).where(UCV.SUID.eq(suid).and(UCV.WID.eq(wid)))
				.fetchAnyInto(UserCourseVideo.class);
	}

	public void updateCourseVideoPlayLength(String suid, String wid, int playLength, int maxPlayLength) {
		mediaCtx.insertInto(UCV, UCV.SUID, UCV.WID, UCV.PLAY_LENGTH, UCV.MAX_PLAY_LENGTH, UCV.STATUS, UCV.CREATE_TIME)
				.values(suid, wid, playLength, maxPlayLength, 0, System.currentTimeMillis()).onDuplicateKeyUpdate()
				.set(UCV.PLAY_LENGTH, playLength).set(UCV.MAX_PLAY_LENGTH, maxPlayLength).execute();
	}

	public void updateCourseVideoStatus(String suid, String wid, int status) {
		mediaCtx.insertInto(UCV, UCV.SUID, UCV.WID, UCV.STATUS, UCV.CREATE_TIME)
				.values(suid, wid, status, System.currentTimeMillis()).onDuplicateKeyUpdate().set(UCV.STATUS, status)
				.execute();
	}

	public List<Map<String, Object>> mutiCalFinishCnt(String suid, Collection<String> pids) {
		String sql = "SELECT pid,COUNT(1) AS num" + " FROM(" + " SELECT wid,pid" + " FROM `tomato_course_pack_video`"
				+ " WHERE pid IN(" + StringUtils.join(Collections.nCopies(pids.size(), "?"), ",") + ")"
				+ " )t1 INNER JOIN(" + " SELECT `wid`" + " FROM `user_course_video`"
				+ " WHERE suid=? AND `status` in(1,2)" + " )t2 ON t1.wid=t2.wid" + " GROUP BY pid";
		List<Object> args = Lists.newArrayList();
		args.addAll(pids);
		args.add(suid);
		return mediaJdbcTemplate.queryForList(sql, args.toArray());
	}

}
