package com.jz.jar.media.repository;

import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.UserCoinTaskSetting;

@Lazy
@Repository
public class UserCoinTaskRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.UserCoinTaskSetting UCTS = Tables.USER_COIN_TASK_SETTING;
	private static final com.jz.jooq.media.tables.UserCoinTaskRecord UCTR = Tables.USER_COIN_TASK_RECORD;

	public List<UserCoinTaskSetting> listSettings() {
		return mediaCtx.selectFrom(UCTS).fetchInto(UserCoinTaskSetting.class);
	}

	public boolean isExistTaskRecord(String uid, String taskId) {
		return mediaCtx.fetchExists(UCTR, UCTR.UID.eq(uid).and(UCTR.TASK_ID.eq(taskId)));
	}

	public void createTaskRecord(String uid, String taskId, Integer num) {
		mediaCtx.insertInto(UCTR, UCTR.UID, UCTR.TASK_ID, UCTR.NUM, UCTR.CREATED)
				.values(uid, taskId, num, System.currentTimeMillis()).execute();
	}

}
