package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.TomatoCourseVideo;

@Lazy
@Repository
public class TomatoCourseVideoRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.TomatoCourseVideo TCV = Tables.TOMATO_COURSE_VIDEO;

	public TomatoCourseVideo getOnlineVideo(String wid) {
		return mediaCtx.selectFrom(TCV).where(TCV.WID.eq(wid).and(TCV.STATUS.eq(1)))
				.fetchAnyInto(TomatoCourseVideo.class);
	}

	public List<TomatoCourseVideo> mutiGetOnlineVideos(Collection<String> wids) {
		return mediaCtx.selectFrom(TCV).where(TCV.WID.in(wids).and(TCV.STATUS.eq(1)))
				.fetchInto(TomatoCourseVideo.class);
	}

}
