package com.jz.jar.media.repository;

import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.media.enums.DbField;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.Quiz;

@Lazy
@Repository
public class QuizRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.Quiz QZ = Tables.QUIZ;

	public Quiz getOnlineQuiz(String qzid) {
		List<Quiz> quizs = mediaCtx.selectFrom(QZ).where(QZ.QZID.eq(qzid).and(QZ.STATUS.eq(DbField.online.name())))
				.fetchInto(Quiz.class);
		return ArrayMapTools.isEmpty(quizs) ? null : quizs.get(0);
	}

	public Quiz getQuiz(String qzid) {
		List<Quiz> quizs = mediaCtx.selectFrom(QZ).where(QZ.QZID.eq(qzid)).fetchInto(Quiz.class);
		return ArrayMapTools.isEmpty(quizs) ? null : quizs.get(0);
	}

	public String getOnlineQuizForLidAndWeek(String lid, int week) {
		List<String> qzids = mediaCtx.select(QZ.QZID).from(QZ)
				.where(QZ.LID.eq(lid).and(QZ.WEEK.eq(week)).and(QZ.STATUS.eq(DbField.online.name())))
				.fetchInto(String.class);
		return ArrayMapTools.isNotEmpty(qzids) ? qzids.get(0) : null;
	}
}
