package com.jz.jar.media.repository;

import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jar.media.enums.AuditStatus;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.WorksThemeRecomm;

@Lazy
@Repository
public class WorksThemeRecommRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.WorksThemeRecomm TR = Tables.WORKS_THEME_RECOMM;
	private static final com.jz.jooq.media.tables.WorksTheme WT = Tables.WORKS_THEME;

	public List<WorksThemeRecomm> findOnlineThemeRecommon() {
		return mediaCtx.select(TR.NAME, TR.PIC, TR.THEME_ID, TR.CONF).from(TR.join(WT).on(TR.THEME_ID.eq(WT.ID)))
				.where(TR.STATUS.eq(AuditStatus.online.getCode()).and(WT.STATUS.eq(AuditStatus.online.getCode())))
				.orderBy(TR.ID.asc()).fetchInto(WorksThemeRecomm.class);
	}

}
