package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.jooq.Record2;
import org.jooq.Result;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.google.common.collect.Maps;
import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.enums.DbField;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.Playlist;

@Lazy
@Repository
public class PlaylistRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.Playlist PL = Tables.PLAYLIST;

	public Playlist getOnlinePlaylist(String pid, BrandEnum brand) {
		return mediaCtx.selectFrom(PL)
				.where(PL.PID.eq(pid).and(PL.BRAND.eq(brand.name())).and(PL.STATUS.eq(DbField.online.name())))
				.fetchAnyInto(Playlist.class);
	}

	public List<Playlist> getOnlinePlaylist(Collection<String> pids, BrandEnum brand) {
		return mediaCtx.selectFrom(PL)
				.where(PL.PID.in(pids).and(PL.BRAND.eq(brand.name())).and(PL.STATUS.eq(DbField.online.name())))
				.fetchInto(Playlist.class);
	}

	public List<Playlist> getPlaylist(int start, int size) {
		return mediaCtx.selectFrom(PL).orderBy(PL.LAST_UPDATE.desc()).limit(start, size).fetchInto(Playlist.class);
	}

	public Map<String, Integer> getPlaylistToVideoCount(Collection<String> pids) {
		Result<Record2<String, Integer>> result = mediaCtx.select(PL.PID, PL.VIDEO_CNT).from(PL).where(PL.PID.in(pids))
				.fetch();
		if (null == result || result.isEmpty())
			return Maps.newHashMap();
		Map<String, Integer> pid2VideoCount = Maps.newHashMap();
		result.forEach(it -> pid2VideoCount.put(it.value1(), it.value2()));
		return pid2VideoCount;
	}

	public String getWidForPlaylist(String pid) {
		return mediaCtx.select(PL.WID).from(PL).where(PL.PID.eq(pid)).fetchAnyInto(String.class);
	}

	public void addWatchCnt(String pid, BrandEnum brand, int cnt) {
		mediaCtx.update(PL).set(PL.WATCH_CNT, PL.WATCH_CNT.add(cnt)).set(PL.LAST_UPDATE, System.currentTimeMillis())
				.where(PL.PID.eq(pid).and(PL.BRAND.eq(brand.name()))).execute();
	}

}
