package com.jz.jar.media.service;

import java.util.Collection;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.media.enums.PlaylistType;
import com.jz.jar.media.repository.TomatoContentAttributesRepository;

@Lazy
@Service
public class TomatoContentAttributesService {

	@Autowired
	private TomatoContentAttributesRepository contentAttributesRepository;

	public List<String> getAttributes(String id, PlaylistType type) {
		return contentAttributesRepository.getAttributes(id, type);
	}

	public List<String> findSidsForAttributes(Collection<String> attrIds, PlaylistType type, int start, int size) {
		return contentAttributesRepository.findSidsForAttributes(attrIds, type, start, size);
	}

}
