/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.repository;

import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.enums.DbField;
import com.jz.jar.media.repository.MediaBaseRepository;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.Playlist;
import com.jz.jooq.media.tables.TomatoPlaylistAttributes;
import java.util.Collection;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class TomatoPlaylistAttributesRepository
extends MediaBaseRepository {
    private static final TomatoPlaylistAttributes PA = Tables.TOMATO_PLAYLIST_ATTRIBUTES;
    private static final Playlist P = Tables.PLAYLIST;

    public List<String> filterPlaylistForAid(Collection<String> pids, String aid) {
        return this.mediaCtx.select((SelectField)TomatoPlaylistAttributesRepository.PA.PID).from((TableLike)PA).where(new Condition[]{TomatoPlaylistAttributesRepository.PA.PID.in(pids).and(TomatoPlaylistAttributesRepository.PA.ATTR_ID.eq((Object)aid))}).fetchInto(String.class);
    }

    public List<String> filterPlaylistForAid(Collection<String> pids, String aid, int start, int size) {
        return this.mediaCtx.select((SelectField)TomatoPlaylistAttributesRepository.PA.PID).from((TableLike)PA).where(new Condition[]{TomatoPlaylistAttributesRepository.PA.PID.in(pids).and(TomatoPlaylistAttributesRepository.PA.ATTR_ID.eq((Object)aid))}).orderBy(TomatoPlaylistAttributesRepository.PA.PID.sortAsc(pids)).limit(start, size).fetchInto(String.class);
    }

    public int countFilterPlaylistForAid(Collection<String> pids, String aid) {
        return (Integer)this.mediaCtx.select((SelectField)DSL.countDistinct((Field)TomatoPlaylistAttributesRepository.PA.PID)).from((TableLike)PA).where(new Condition[]{TomatoPlaylistAttributesRepository.PA.PID.in(pids).and(TomatoPlaylistAttributesRepository.PA.ATTR_ID.eq((Object)aid))}).fetchAnyInto(Integer.class);
    }

    public List<com.jz.jooq.media.tables.pojos.TomatoPlaylistAttributes> filterPlaylistForAid(Collection<String> pids, Collection<String> aids) {
        return this.mediaCtx.selectFrom((Table)PA).where(new Condition[]{TomatoPlaylistAttributesRepository.PA.PID.in(pids).and(TomatoPlaylistAttributesRepository.PA.ATTR_ID.in(aids))}).fetchInto(com.jz.jooq.media.tables.pojos.TomatoPlaylistAttributes.class);
    }

    public List<String> findAttributeIds(Collection<String> pids) {
        return this.mediaCtx.selectDistinct((SelectField)TomatoPlaylistAttributesRepository.PA.ATTR_ID).from((TableLike)PA).where(new Condition[]{TomatoPlaylistAttributesRepository.PA.PID.in(pids)}).fetchInto(String.class);
    }

    public List<String> findPlaylistForAttrId(BrandEnum brand, String aid) {
        return this.mediaCtx.select((SelectField)TomatoPlaylistAttributesRepository.PA.PID).from((TableLike)PA.join((TableLike)P).on(new Condition[]{TomatoPlaylistAttributesRepository.PA.PID.eq((Field)TomatoPlaylistAttributesRepository.P.PID)})).where(new Condition[]{TomatoPlaylistAttributesRepository.PA.ATTR_ID.eq((Object)aid).and(TomatoPlaylistAttributesRepository.P.BRAND.eq((Object)brand.name())).and(TomatoPlaylistAttributesRepository.P.STATUS.eq((Object)DbField.online.name()))}).orderBy(TomatoPlaylistAttributesRepository.P.CREATE_TIME.desc()).fetchInto(String.class);
    }

    public List<com.jz.jooq.media.tables.pojos.TomatoPlaylistAttributes> findPlaylistForAttrId(BrandEnum brand, Collection<String> aids) {
        return this.mediaCtx.select((SelectField)TomatoPlaylistAttributesRepository.PA.ATTR_ID, (SelectField)TomatoPlaylistAttributesRepository.PA.PID).from((TableLike)PA.join((TableLike)P).on(new Condition[]{TomatoPlaylistAttributesRepository.PA.PID.eq((Field)TomatoPlaylistAttributesRepository.P.PID)})).where(new Condition[]{TomatoPlaylistAttributesRepository.PA.ATTR_ID.in(aids).and(TomatoPlaylistAttributesRepository.P.BRAND.eq((Object)brand.name())).and(TomatoPlaylistAttributesRepository.P.STATUS.eq((Object)DbField.online.name()))}).orderBy(TomatoPlaylistAttributesRepository.P.CREATE_TIME.desc()).fetchInto(com.jz.jooq.media.tables.pojos.TomatoPlaylistAttributes.class);
    }
}

