package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.PlaylistPics;

@Lazy
@Repository
public class PlaylistPicsRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.PlaylistPics PP = Tables.PLAYLIST_PICS;

	public List<PlaylistPics> getPics(String pid) {
		return mediaCtx.selectFrom(PP).where(PP.PID.eq(pid)).fetchInto(PlaylistPics.class);
	}

	public List<PlaylistPics> getPics(Collection<String> pids) {
		return mediaCtx.selectFrom(PP).where(PP.PID.in(pids)).fetchInto(PlaylistPics.class);
	}

}
