/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.repository;

import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.enums.DbField;
import com.jz.jar.media.repository.MediaBaseRepository;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.SysNotify;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Table;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class SysNotifyRepository
extends MediaBaseRepository {
    private static final SysNotify SYS = Tables.SYS_NOTIFY;

    private Condition getCondition(BrandEnum brand, String uid) {
        return SysNotifyRepository.SYS.UID.in((Object[])new String[]{DbField.all.name(), uid}).and(SysNotifyRepository.SYS.BRAND.eq((Object)brand.name()));
    }

    public int countUnreadNotifies(BrandEnum brand, String uid, long timestamp) {
        return this.mediaCtx.fetchCount((Table)SYS, this.getCondition(brand, uid).and(SysNotifyRepository.SYS.CREATE_TIME.gt((Object)timestamp)));
    }

    public int countNotifies(BrandEnum brand, String uid) {
        return this.mediaCtx.fetchCount((Table)SYS, this.getCondition(brand, uid));
    }

    public List<com.jz.jooq.media.tables.pojos.SysNotify> findNotifies(BrandEnum brand, String uid, int start, int size) {
        return this.mediaCtx.selectFrom((Table)SYS).where(new Condition[]{this.getCondition(brand, uid)}).orderBy(SysNotifyRepository.SYS.CREATE_TIME.desc()).limit(start, size).fetchInto(com.jz.jooq.media.tables.pojos.SysNotify.class);
    }
}

