package com.jz.jar.media.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.repository.WorksInfoRepository;
import com.jz.jooq.media.tables.pojos.WorksInfo;

@Lazy
@Service
public class WorksInfoService {

	@Autowired
	private WorksInfoRepository worksInfoRepository;

	public boolean existWorksInfo(String id, BrandEnum brand) {
		return worksInfoRepository.existWorksInfo(id, brand);
	}

	public WorksInfo getWorksInfo(String id, BrandEnum brand) {
		return worksInfoRepository.getWorksInfo(id, brand);
	}

	public WorksInfo getSimpleWorksInfo(String id, BrandEnum brand) {
		return worksInfoRepository.getSimpleWorksInfo(id, brand);
	}

	public List<WorksInfo> findSimpleWorksInfo(Collection<String> artIds) {
		return worksInfoRepository.findSimpleWorksInfo(artIds);
	}

	public void updateOpenInfo(String id, BrandEnum brand, int isOpen) {
		worksInfoRepository.updateOpenInfo(id, brand, isOpen);
	}

	public int countOpenNewWorks(BrandEnum brand, Collection<String> uids, long timestamp) {
		return worksInfoRepository.countOpenNewWorks(brand, uids, timestamp);
	}

	public int countOpenWorks(BrandEnum brand, Collection<String> uids) {
		return worksInfoRepository.countOpenWorks(brand, uids);
	}

	public List<String> findOpenWorksId(BrandEnum brand, Collection<String> uids, int start, int size) {
		return worksInfoRepository.findOpenWorksId(brand, uids, start, size);
	}

	public int countRecommonWorks(BrandEnum brand) {
		return worksInfoRepository.countRecommonWorks(brand);
	}

	public List<String> findRecommonWorksId(BrandEnum brand, int start, int size) {
		return worksInfoRepository.findRecommonWorksId(brand, start, size);
	}

	/** 获取存在作品的学校及课程 */
	public List<WorksInfo> findExistWorksInfo(Map<String, Collection<String>> school2LessonIds, String suid) {
		return worksInfoRepository.findExistWorksInfo(school2LessonIds, suid);
	}

	public int countStudentWorks(BrandEnum brand, String puid, String suid) {
		return worksInfoRepository.countStudentWorks(brand, puid, suid);
	}

	public List<String> findStudentWorksId(BrandEnum brand, String puid, String suid, int start, int size) {
		return worksInfoRepository.findStudentWorksId(brand, puid, suid, start, size);
	}

	public List<String> findAllStudentWorksId(BrandEnum brand, String puid, String suid) {
		return worksInfoRepository.findAllStudentWorksId(brand, puid, suid);
	}
}
