package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.PlaylistTags;

@Lazy
@Repository
public class PlaylistTagsRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.PlaylistTags PT = Tables.PLAYLIST_TAGS;

	public List<String> getTagsForPlaylist(String pid) {
		return mediaCtx.selectDistinct(PT.TID).from(PT).where(PT.PID.eq(pid)).fetchInto(String.class);
	}

	public List<String> findTagsForPlaylistIds(List<String> pids) {
		return mediaCtx.selectDistinct(PT.TID).from(PT).where(PT.PID.in(pids)).fetchInto(String.class);
	}

	public int countPlaylistForPlaylistAndTag(List<String> pids, String tid) {
		return mediaCtx.fetchCount(PT, PT.PID.in(pids).and(PT.TID.eq(tid)));
	}

	public List<String> findPlaylistForPlaylistAndTag(List<String> pids, String tid, int start, int size) {
		return mediaCtx.select(PT.PID).from(PT).where(PT.PID.in(pids).and(PT.TID.eq(tid))).orderBy(PT.SEQ.asc())
				.limit(start, size).fetchInto(String.class);
	}

	public List<PlaylistTags> findPlaylistTagInfoForTags(Collection<String> tids) {
		return mediaCtx.selectFrom(PT).where(PT.TID.in(tids)).orderBy(PT.SEQ.asc()).fetchInto(PlaylistTags.class);
	}
}
