/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.proxy;

import com.google.common.collect.Lists;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.collection.OrderTool;
import com.jz.common.utils.json.GsonTools;
import com.jz.common.utils.text.StringTools;
import com.jz.jar.media.beans.ArtResource;
import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.proxy.UserProxy;
import com.jz.jar.media.request.ArtRequest;
import com.jz.jar.media.request.UserRequest;
import com.jz.jar.media.service.ArtInfoService;
import com.jz.jar.media.service.ArtLikeService;
import com.jz.jar.media.tool.AliyunBean;
import com.jz.jar.media.tool.PictureCompress;
import com.jz.jar.media.wrapper.ArtInfoWrapper;
import com.jz.jar.media.wrapper.UserWrapper;
import com.jz.jooq.media.tables.pojos.ArtInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class ArtInfoProxy {
    @Autowired
    private ArtInfoService artInfoService;
    @Autowired
    private ArtLikeService artLikeService;
    @Autowired
    private UserProxy userProxy;

    public List<ArtInfoWrapper> getSimpleArtInfo(BrandEnum brand, ArtRequest request) {
        List artInfos = this.artInfoService.findSimpleArtInfo(request.getArtIds());
        if (ArrayMapTools.isEmpty((Collection)artInfos)) {
            return null;
        }
        Set<String> puids = artInfos.stream().map(ArtInfo::getPuid).collect(Collectors.toSet());
        Map<String, UserWrapper> uid2User = this.userProxy.getSimpleParentInfoHas(brand, UserRequest.of(puids));
        Map likeCount = this.artLikeService.getLikeCount(request.getArtIds());
        List likes = this.artLikeService.screenLike(request.getArtIds(), request.getUid());
        ArrayList wrappers = Lists.newArrayList();
        for (ArtInfo artInfo : artInfos) {
            ArtResource resource = (ArtResource)GsonTools.gson.fromJson(artInfo.getResource(), ArtResource.class);
            if (null == resource) continue;
            ArtInfoWrapper wrapper = ArtInfoWrapper.of(artInfo);
            wrapper.setType(resource.getType()).setWid(resource.getWid());
            wrapper.setPic(AliyunBean.getImagesUrl(resource.getPic(), PictureCompress._60));
            wrapper.setUser(uid2User.get(artInfo.getPuid()));
            wrapper.setLikeCnt(MapUtils.getInteger((Map)likeCount, (Object)artInfo.getId(), (Integer)0));
            wrapper.setIsLike(likes.contains(artInfo.getId()));
            wrappers.add(wrapper);
        }
        return OrderTool.keepOrder(request.getArtIds(), (Collection)wrappers, ArtInfoWrapper::getId);
    }

    public ArtInfoWrapper getArtInfo(BrandEnum brand, ArtRequest request) {
        ArtInfo artInfo = this.artInfoService.getArtInfo(request.getArtId(), brand);
        if (null == artInfo || StringTools.isEmpty((CharSequence)artInfo.getResource())) {
            return null;
        }
        boolean isMaster = artInfo.getPuid().equals(request.getUid());
        if (artInfo.getIsOpen() <= 0 && !isMaster) {
            return null;
        }
        ArtResource resource = (ArtResource)GsonTools.gson.fromJson(artInfo.getResource(), ArtResource.class);
        if (null == resource) {
            return null;
        }
        ArtInfoWrapper wrapper = ArtInfoWrapper.of(artInfo);
        wrapper.setType(resource.getType()).setWid(resource.getWid());
        wrapper.setPic(AliyunBean.getImagesUrl(resource.getPic(), PictureCompress._60));
        if (null != resource.getPictures()) {
            ArrayList pictures = Lists.newArrayList();
            resource.getPictures().forEach(it -> pictures.add(AliyunBean.getImagesUrl(it, PictureCompress._60)));
            wrapper.setPictures(pictures);
        }
        wrapper.setLikeCnt(this.artLikeService.countForArtId(artInfo.getId()));
        wrapper.setIsLike(this.artLikeService.existForIdAndUid(artInfo.getId(), request.getUid()));
        wrapper.setUser((UserWrapper)this.userProxy.getSimpleParentInfo(brand, UserRequest.of(request.getUid(), artInfo.getPuid())));
        if (request.getWithStudent().booleanValue()) {
            wrapper.setStudent(this.userProxy.getStudentInfo(artInfo.getSuid(), true, brand));
        }
        return wrapper;
    }
}

