package com.jz.jar.media.wrapper;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.jz.jooq.media.tables.pojos.ArtInfo;

public class ArtInfoWrapper {
	private ArtInfoWrapper() {
	}

	private String id;
	private String title;
	private String material; // 材料
	private String appraise; // 评价
	private Boolean isOpen; // 是否公开
	private Long createTime;

	private String type; // v : p
	private String pic; // 封面图
	private String wid; // 视频id
	private List<String> pictures; // 图片集

	private UserWrapper user;
	private StudentWrapper student;

	private Integer likeCnt;
	private Boolean isLike; // 当前用户是否已经喜欢
	private String lessonTitle; // 课程名称
	private Long lessonStartTime;
	private Long lessonEndTime;
	private TeacherWrapper teacher;

	private String schoolId;
	private String lessonId;

	public static ArtInfoWrapper of(ArtInfo artInfo) {
		return new ArtInfoWrapper().setId(artInfo.getId()).setTitle(artInfo.getTitle())
				.setMaterial(artInfo.getMaterial()).setAppraise(artInfo.getAppraise()).setIsOpen(artInfo.getIsOpen())
				.setCreateTime(artInfo.getCreateTime()).setSchoolId(artInfo.getSchoolId())
				.setLessonId(artInfo.getLessonId());
	}

	public String getId() {
		return id;
	}

	public ArtInfoWrapper setId(String id) {
		this.id = id;
		return this;
	}

	public String getTitle() {
		return title;
	}

	public ArtInfoWrapper setTitle(String title) {
		this.title = title;
		return this;
	}

	public String getMaterial() {
		return material;
	}

	public ArtInfoWrapper setMaterial(String material) {
		this.material = material;
		return this;
	}

	public String getAppraise() {
		return appraise;
	}

	public ArtInfoWrapper setAppraise(String appraise) {
		this.appraise = appraise;
		return this;
	}

	public Boolean getIsOpen() {
		return isOpen;
	}

	public ArtInfoWrapper setIsOpen(Integer isOpen) {
		if (null == isOpen)
			return this;
		this.isOpen = isOpen > 0;
		return this;
	}

	public String getType() {
		return type;
	}

	public ArtInfoWrapper setType(String type) {
		this.type = type;
		return this;
	}

	public String getPic() {
		return pic;
	}

	public ArtInfoWrapper setPic(String pic) {
		this.pic = pic;
		return this;
	}

	public String getWid() {
		return wid;
	}

	public ArtInfoWrapper setWid(String wid) {
		this.wid = wid;
		return this;
	}

	public List<String> getPictures() {
		return pictures;
	}

	public ArtInfoWrapper setPictures(List<String> pictures) {
		this.pictures = pictures;
		return this;
	}

	public Long getCreateTime() {
		return createTime;
	}

	public ArtInfoWrapper setCreateTime(Long createTime) {
		this.createTime = createTime;
		return this;
	}

	public UserWrapper getUser() {
		return user;
	}

	public ArtInfoWrapper setUser(UserWrapper user) {
		this.user = user;
		return this;
	}

	public StudentWrapper getStudent() {
		return student;
	}

	public ArtInfoWrapper setStudent(StudentWrapper student) {
		this.student = student;
		return this;
	}

	public Boolean getIsLike() {
		return isLike;
	}

	public ArtInfoWrapper setIsLike(Boolean isLike) {
		this.isLike = isLike;
		return this;
	}

	public Integer getLikeCnt() {
		return likeCnt;
	}

	public ArtInfoWrapper setLikeCnt(Integer likeCnt) {
		this.likeCnt = likeCnt;
		return this;
	}

	public String getLessonTitle() {
		return lessonTitle;
	}

	public ArtInfoWrapper setLessonTitle(String lessonTitle) {
		this.lessonTitle = lessonTitle;
		return this;
	}

	public Long getLessonStartTime() {
		return lessonStartTime;
	}

	public ArtInfoWrapper setLessonStartTime(Long lessonStartTime) {
		this.lessonStartTime = lessonStartTime;
		return this;
	}

	public Long getLessonEndTime() {
		return lessonEndTime;
	}

	public ArtInfoWrapper setLessonEndTime(Long lessonEndTime) {
		this.lessonEndTime = lessonEndTime;
		return this;
	}

	public TeacherWrapper getTeacher() {
		return teacher;
	}

	public ArtInfoWrapper setTeacher(TeacherWrapper teacher) {
		this.teacher = teacher;
		return this;
	}

	@JsonIgnore
	public String getSchoolId() {
		return schoolId;
	}

	public ArtInfoWrapper setSchoolId(String schoolId) {
		this.schoolId = schoolId;
		return this;
	}

	@JsonIgnore
	public String getLessonId() {
		return lessonId;
	}

	public ArtInfoWrapper setLessonId(String lessonId) {
		this.lessonId = lessonId;
		return this;
	}

}
