package com.jz.jar.media.proxy;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.text.StringTools;
import com.jz.jar.franchise.service.ContractService;
import com.jz.jar.franchise.service.StudentInfoService;
import com.jz.jar.franchise.service.StudentSchoolContractService;
import com.jz.jar.franchise.service.StudentSchoolService;
import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.service.UserSignService;
import com.jz.jar.media.tool.AliyunBean;
import com.jz.jar.media.tool.MediaGlobal;
import com.jz.jar.media.tool.PictureCompress;
import com.jz.jar.media.wrapper.StudentWrapper;
import com.jz.jooq.franchise.tables.pojos.StudentInfo;
import com.jz.jooq.media.tables.pojos.Level;

/**
 * @Title UserProxy
 * @Package com.jz.jar.media.proxy
 * @author tangjunfeng
 * @date 2019年1月11日 上午11:59:14
 * @version V1.0
 */
@Lazy
@Service
public class UserProxy {

	@Autowired
	private StudentInfoService studentInfoService;
	@Autowired
	private StudentSchoolService studentSchoolService;
	@Autowired
	private StudentSchoolContractService studentSchoolContractService;
	@Autowired
	private UserSignService userSignService;
	@Autowired
	private ContractService contractService;
	@Autowired
	private LevelProxy levelProxy;
	
	public Level getLevelForAge(String suid, BrandEnum brand) {
		if (StringTools.isEmptyAndBlank(suid))
			return null;
		String birthday = studentInfoService.getStudentBirthday(suid);
		if (StringTools.isEmptyAndBlank(birthday))
			return null;
		return levelProxy.getLevelForAge(MediaGlobal.getAge(birthday), brand);
	}
	
	public String getLidForBirthday(String birthday, BrandEnum brand) {
		if (StringTools.isEmptyAndBlank(birthday))
			return null;
		System.out.println("MediaGlobal.getAge(birthday) : " + MediaGlobal.getAge(birthday));
		return levelProxy.getLevelForAge(MediaGlobal.getAge(birthday), brand).getLid();
	}

	/** 获取用户下的所有学员 */
	public List<StudentWrapper> getChildrenStudentInfo(String puid, BrandEnum brand) {
		List<StudentInfo> students = studentInfoService.getStudents(puid);
		if (ArrayMapTools.isEmpty(students))
			return null;
		List<String> suids = students.stream().map(it -> it.getSuid()).collect(Collectors.toList());
		// 拆分playabc展示的内容
		Map<String, Integer> suid2Cnt = null;
		Map<String, Pair<Integer, Integer>> hasLession = null;
		List<String> containSchoolSuids = Lists.newArrayList();
		if (brand == BrandEnum.playabc) {
			suid2Cnt = userSignService.getCountDays(puid, suids);
			hasLession = studentSchoolContractService.getLessionCount(suids);
			containSchoolSuids.addAll(studentSchoolService.getContainsSchool(suids));
		}
		boolean isHaveContract = contractService.isHaveContract(puid);
		List<StudentWrapper> wrappers = Lists.newArrayList();
		for (StudentInfo st : students) {
			wrappers.add(getWrapper(st, MediaGlobal.getMapValue(suid2Cnt, st.getSuid()),
					MediaGlobal.getMapValue(hasLession, st.getSuid()), containSchoolSuids.contains(st.getSuid()),
					isHaveContract, false, brand));
		}
		return wrappers;
	}

	/** 获取用户下的所有学员 */
	public StudentWrapper getStudentInfo(String suid, boolean isSimple, BrandEnum brand) {
		StudentInfo st = studentInfoService.getStudent(suid);
		if (null == st)
			return null;
		if (isSimple || brand == BrandEnum.tomato)
			return getWrapper(st, null, null, false, false, true, brand);
		Pair<Integer, Integer> lessionCount = studentSchoolContractService.getLessionCount(st.getSuid());
		int signCnt = userSignService.countDays(st.getPuid(), suid);
		return getWrapper(st, signCnt, lessionCount, studentSchoolService.isContainsSchool(suid),
				contractService.isHaveContract(st.getPuid()), false, brand);
	}

	private StudentWrapper getWrapper(StudentInfo st, Integer signCnt, Pair<Integer, Integer> lessionCount,
			boolean isContainSchool, boolean isHaveContract, boolean isSimple, BrandEnum brand) {
		StudentWrapper student = StudentWrapper.of(st).setAge(getShowStudentAge(st, true))
				.setLevel(this.getLidForBirthday(st.getBirthday(), brand)).setSignCnt(signCnt)
				.setAvatar(AliyunBean.getImagesUrl(st.getAvatar(), PictureCompress._30));
		if (isSimple || brand == BrandEnum.tomato)
			return student;
		student.setIsContainSchool(isContainSchool).setIsHaveContract(isHaveContract);
		if (null == lessionCount)
			return student.setTotalLession(0).setRemainingLession(0);
		student.setTotalLession(lessionCount.getLeft())
				.setRemainingLession(lessionCount.getLeft() - lessionCount.getRight());
		return student;
	}

	/** 获取学员的年龄 */
	public String getShowStudentAge(StudentInfo studentInfo, boolean isShowMonth) {
		Pair<Integer, Integer> yearOfMonth = MediaGlobal.getAgeMonth(studentInfo.getBirthday());
		StringBuffer sb = new StringBuffer().append(getAgeContent(yearOfMonth.getLeft(), "岁"));
		if (isShowMonth)
			sb.append(getAgeContent(yearOfMonth.getRight(), "个月"));
		return sb.toString();
	}

	private static String getAgeContent(int num, String content) {
		return num <= 0 ? "" : num + content;
	}
}
