/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.proxy;

import com.google.common.collect.Lists;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.text.StringTools;
import com.jz.jar.franchise.service.ContractService;
import com.jz.jar.franchise.service.StudentInfoService;
import com.jz.jar.franchise.service.StudentSchoolContractService;
import com.jz.jar.franchise.service.StudentSchoolService;
import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.proxy.LevelProxy;
import com.jz.jar.media.service.UserSignService;
import com.jz.jar.media.tool.AliyunBean;
import com.jz.jar.media.tool.MediaGlobal;
import com.jz.jar.media.tool.PictureCompress;
import com.jz.jar.media.wrapper.StudentWrapper;
import com.jz.jooq.franchise.tables.pojos.StudentInfo;
import com.jz.jooq.media.tables.pojos.Level;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class UserProxy {
    @Autowired
    private StudentInfoService studentInfoService;
    @Autowired
    private StudentSchoolService studentSchoolService;
    @Autowired
    private StudentSchoolContractService studentSchoolContractService;
    @Autowired
    private UserSignService userSignService;
    @Autowired
    private ContractService contractService;
    @Autowired
    private LevelProxy levelProxy;

    public Level getLevelForAge(String suid, BrandEnum brand) {
        if (StringTools.isEmptyAndBlank((String)suid)) {
            return null;
        }
        String birthday = this.studentInfoService.getStudentBirthday(suid);
        if (StringTools.isEmptyAndBlank((String)birthday)) {
            return null;
        }
        return this.levelProxy.getLevelForAge(MediaGlobal.getAge(birthday).floatValue(), brand);
    }

    public String getLidForBirthday(String birthday, BrandEnum brand) {
        if (StringTools.isEmptyAndBlank((String)birthday)) {
            return null;
        }
        System.out.println("birthday : " + birthday);
        System.out.println("birthday : " + MediaGlobal.getAge(birthday));
        return this.levelProxy.getLevelForAge(MediaGlobal.getAge(birthday).floatValue(), brand).getLid();
    }

    public List<StudentWrapper> getChildrenStudentInfo(String puid, BrandEnum brand) {
        List students = this.studentInfoService.getStudents(puid);
        if (ArrayMapTools.isEmpty((Collection)students)) {
            return null;
        }
        List suids = students.stream().map(it -> it.getSuid()).collect(Collectors.toList());
        Map suid2Cnt = null;
        Map hasLession = null;
        ArrayList containSchoolSuids = Lists.newArrayList();
        if (brand == BrandEnum.playabc) {
            suid2Cnt = this.userSignService.getCountDays(puid, suids);
            hasLession = this.studentSchoolContractService.getLessionCount(suids);
            containSchoolSuids.addAll(this.studentSchoolService.getContainsSchool(suids));
        }
        boolean isHaveContract = this.contractService.isHaveContract(puid);
        ArrayList wrappers = Lists.newArrayList();
        for (StudentInfo st : students) {
            wrappers.add(this.getWrapper(st, (Integer)MediaGlobal.getMapValue(suid2Cnt, st.getSuid()), (Pair<Integer, Integer>)((Pair)MediaGlobal.getMapValue(hasLession, st.getSuid())), containSchoolSuids.contains(st.getSuid()), isHaveContract, false, brand));
        }
        return wrappers;
    }

    public StudentWrapper getStudentInfo(String suid, boolean isSimple, BrandEnum brand) {
        StudentInfo st = this.studentInfoService.getStudent(suid);
        if (null == st) {
            return null;
        }
        if (isSimple || brand == BrandEnum.tomato) {
            return this.getWrapper(st, null, null, false, false, true, brand);
        }
        Pair lessionCount = this.studentSchoolContractService.getLessionCount(st.getSuid());
        int signCnt = this.userSignService.countDays(st.getPuid(), suid);
        return this.getWrapper(st, signCnt, (Pair<Integer, Integer>)lessionCount, this.studentSchoolService.isContainsSchool(suid), this.contractService.isHaveContract(st.getPuid()), false, brand);
    }

    private StudentWrapper getWrapper(StudentInfo st, Integer signCnt, Pair<Integer, Integer> lessionCount, boolean isContainSchool, boolean isHaveContract, boolean isSimple, BrandEnum brand) {
        StudentWrapper student = StudentWrapper.of(st).setAge(this.getShowStudentAge(st, true)).setLevel(this.getLidForBirthday(st.getBirthday(), brand)).setSignCnt(signCnt).setAvatar(AliyunBean.getImagesUrl(st.getAvatar(), PictureCompress._30));
        if (isSimple || brand == BrandEnum.tomato) {
            return student;
        }
        student.setIsContainSchool(isContainSchool).setIsHaveContract(isHaveContract);
        if (null == lessionCount) {
            return student.setTotalLession(0).setRemainingLession(0);
        }
        student.setTotalLession((Integer)lessionCount.getLeft()).setRemainingLession((Integer)lessionCount.getLeft() - (Integer)lessionCount.getRight());
        return student;
    }

    public String getShowStudentAge(StudentInfo studentInfo, boolean isShowMonth) {
        Pair<Integer, Integer> yearOfMonth = MediaGlobal.getAgeMonth(studentInfo.getBirthday());
        StringBuffer sb = new StringBuffer().append(UserProxy.getAgeContent((Integer)yearOfMonth.getLeft(), "\u5c81"));
        if (isShowMonth) {
            sb.append(UserProxy.getAgeContent((Integer)yearOfMonth.getRight(), "\u4e2a\u6708"));
        }
        return sb.toString();
    }

    private static String getAgeContent(int num, String content) {
        return num <= 0 ? "" : num + content;
    }
}

