/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.common;

import com.jz.jar.media.common.CardType;
import com.jz.jar.media.wrapper.CommentWrapper;
import com.jz.jar.media.wrapper.LessonFeedbackWrapper;
import com.jz.jar.media.wrapper.LessonWrapper;
import com.jz.jar.media.wrapper.LevelWrapper;
import com.jz.jar.media.wrapper.PlaylistWrapper;
import com.jz.jar.media.wrapper.TopicWrapper;
import com.jz.jar.media.wrapper.UserNoticeWrapper;
import com.jz.jar.media.wrapper.VideoWrapper;

public class ItemCard {
    private CardType type;
    private VideoWrapper video;
    private PlaylistWrapper playlist;
    private LevelWrapper level;
    private TopicWrapper topic;
    private UserNoticeWrapper notice;
    private LessonWrapper lesson;
    private LessonFeedbackWrapper lessonFb;
    private CommentWrapper comment;

    private ItemCard() {
    }

    private ItemCard(CardType type) {
        this.type = type;
    }

    public static ItemCard of() {
        return new ItemCard();
    }

    public static ItemCard of(VideoWrapper video) {
        return new ItemCard(CardType.video).setVideo(video);
    }

    public static ItemCard of(PlaylistWrapper playlist) {
        return new ItemCard(CardType.playlist).setPlaylist(playlist);
    }

    public static ItemCard of(LevelWrapper level) {
        return new ItemCard(CardType.level).setLevel(level);
    }

    public static ItemCard of(TopicWrapper topic) {
        return new ItemCard(CardType.topic).setTopic(topic);
    }

    public static ItemCard of(UserNoticeWrapper notice) {
        return new ItemCard(CardType.notice).setNotice(notice);
    }

    public static ItemCard of(LessonWrapper lesson) {
        return new ItemCard(CardType.lesson).setLesson(lesson);
    }

    public static ItemCard of(LessonFeedbackWrapper lessonFb) {
        return new ItemCard(CardType.lessonFb).setLessonFb(lessonFb);
    }

    public static ItemCard of(CommentWrapper comment) {
        return new ItemCard(CardType.comment).setComment(comment);
    }

    public CardType getType() {
        return this.type;
    }

    public ItemCard setType(CardType type) {
        this.type = type;
        return this;
    }

    public VideoWrapper getVideo() {
        return this.video;
    }

    public ItemCard setVideo(VideoWrapper video) {
        this.video = video;
        return this;
    }

    public PlaylistWrapper getPlaylist() {
        return this.playlist;
    }

    public ItemCard setPlaylist(PlaylistWrapper playlist) {
        this.playlist = playlist;
        return this;
    }

    public LevelWrapper getLevel() {
        return this.level;
    }

    public ItemCard setLevel(LevelWrapper level) {
        this.level = level;
        return this;
    }

    public TopicWrapper getTopic() {
        return this.topic;
    }

    public ItemCard setTopic(TopicWrapper topic) {
        this.topic = topic;
        return this;
    }

    public UserNoticeWrapper getNotice() {
        return this.notice;
    }

    public ItemCard setNotice(UserNoticeWrapper notice) {
        this.notice = notice;
        return this;
    }

    public LessonWrapper getLesson() {
        return this.lesson;
    }

    public ItemCard setLesson(LessonWrapper lesson) {
        this.lesson = lesson;
        return this;
    }

    public LessonFeedbackWrapper getLessonFb() {
        return this.lessonFb;
    }

    public ItemCard setLessonFb(LessonFeedbackWrapper lessonFb) {
        this.lessonFb = lessonFb;
        return this;
    }

    public CommentWrapper getComment() {
        return this.comment;
    }

    public ItemCard setComment(CommentWrapper comment) {
        this.comment = comment;
        return this;
    }
}

