/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.proxy;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.service.LevelService;
import com.jz.jooq.media.tables.pojos.Level;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Lazy
@Service
@EnableScheduling
public class LevelProxy {
    private static final Map<BrandEnum, List<Level>> brand2LevelArray = Maps.newLinkedHashMap();
    @Autowired
    private LevelService levelService;

    @PostConstruct
    @Scheduled(cron="0 */5 * * * ?")
    public void loadLevelCache() {
        List levels = this.levelService.find();
        if (ArrayMapTools.isEmpty((Collection)levels)) {
            return;
        }
        brand2LevelArray.clear();
        levels.forEach(it -> {
            BrandEnum brand = BrandEnum.valueOf((String)it.getBrand());
            if (!brand2LevelArray.containsKey(brand)) {
                brand2LevelArray.put(brand, Lists.newArrayList());
            }
            brand2LevelArray.get(brand).add((Level)it);
        });
    }

    public Level getLevelForAge(double age, BrandEnum brand) {
        if (!brand2LevelArray.containsKey(brand)) {
            return null;
        }
        for (Level le : brand2LevelArray.get(brand)) {
            if (!(le.getMinAge() <= age) || !(age <= le.getMaxAge())) continue;
            return le;
        }
        return null;
    }
}

