/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.proxy;

import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.enums.DbField;
import com.jz.jar.media.proxy.VideoProxy;
import com.jz.jar.media.request.NextPlayVideoRequest;
import com.jz.jar.media.request.VideoRequest;
import com.jz.jar.media.service.PlaylistService;
import com.jz.jar.media.service.PlaylistVideoService;
import com.jz.jar.media.service.TaskPlayHistoryService;
import com.jz.jar.media.service.UserPlayHistoryService;
import com.jz.jar.media.wrapper.VideoWrapper;
import com.jz.jooq.media.tables.pojos.UserPlayHistory;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class PlaylistVideoProxy {
    @Autowired
    private PlaylistService playlistService;
    @Autowired
    private UserPlayHistoryService userPlayHistoryService;
    @Autowired
    private PlaylistVideoService playlistVideoService;
    @Autowired
    private TaskPlayHistoryService taskPlayHistoryService;
    @Autowired
    private VideoProxy videoProxy;

    public String getNextPlayVideo(String pid, String wid) {
        List wids = this.playlistVideoService.findWids(pid);
        if (ArrayMapTools.isEmpty((Collection)wids) || !wids.contains(wid)) {
            return wid;
        }
        String lastWid = (String)wids.get(wids.size() - 1);
        if (lastWid.equals(wid)) {
            return (String)wids.get(0);
        }
        for (int i = 0; i < wids.size(); ++i) {
            if (!wid.equals(wids.get(i))) continue;
            return (String)wids.get(i + 1);
        }
        return wid;
    }

    public VideoWrapper getNextPlayVideoForHistory(String uid, String pid, String firstWid, BrandEnum brand) {
        VideoWrapper videoInfo;
        UserPlayHistory history;
        int playlength = 0;
        String nextWid = firstWid;
        if (null != uid && null != (history = this.userPlayHistoryService.getHistory(uid, pid))) {
            playlength = history.getPlayLength();
            nextWid = history.getNextWid();
        }
        if (null == nextWid) {
            nextWid = this.playlistService.getWidForPlaylist(pid);
        }
        if (null != (videoInfo = this.videoProxy.getVideoInfo(VideoRequest.of(uid, pid, nextWid), brand))) {
            videoInfo.setPlayLength(playlength);
        }
        return videoInfo;
    }

    public Map<String, VideoWrapper> getNextPlayVideoForHistory(NextPlayVideoRequest request) {
        List histories;
        HashMap pid2Wid = Maps.newHashMap();
        Set pids = request.getPlaylist().stream().map(it -> it.getPid()).collect(Collectors.toSet());
        if (null != request.getSuid()) {
            String tk;
            List playHistories;
            DbField field = null;
            if (request.getIsSpecial().booleanValue()) {
                field = DbField.special;
            } else if (request.getIsEverday().booleanValue()) {
                field = DbField.everday;
            }
            if (null != field && ArrayMapTools.isNotEmpty((Collection)(playHistories = this.taskPlayHistoryService.findPlayHistories(tk = this.taskPlayHistoryService.getTk(field), request.getSuid(), pids)))) {
                playHistories.forEach(it -> pid2Wid.put(it.getPid(), it.getWid()));
                pids.removeAll(pid2Wid.keySet());
            }
        }
        HashMap wid2Playlength = Maps.newHashMap();
        if (!pids.isEmpty() && null != request.getUid() && ArrayMapTools.isNotEmpty((Collection)(histories = this.userPlayHistoryService.getHistories(request.getUid(), pids)))) {
            histories.forEach(it -> {
                pid2Wid.put(it.getPid(), it.getNextWid());
                wid2Playlength.put(it.getNextWid(), it.getPlayLength());
            });
            pids.removeAll(pid2Wid.keySet());
        }
        if (!pids.isEmpty()) {
            request.getPlaylist().forEach(it -> {
                if (pids.contains(it.getPid())) {
                    pid2Wid.put(it.getPid(), it.getWid());
                }
            });
        }
        HashMap pid2VideoCard = Maps.newHashMap();
        List<VideoWrapper> videoInfo = this.videoProxy.getVideoInfoNotPid(VideoRequest.of(request.getUid(), pid2Wid.values()));
        if (ArrayMapTools.isEmpty(videoInfo)) {
            return pid2VideoCard;
        }
        HashMap wid2Video = Maps.newHashMap();
        videoInfo.forEach(it -> {
            wid2Video.put(it.getWid(), it);
            if (wid2Playlength.containsKey(it.getWid())) {
                it.setPlayLength((Integer)wid2Playlength.get(it.getWid()));
            } else {
                it.setPlayLength(0);
            }
        });
        pid2Wid.forEach((tp, tw) -> {
            VideoWrapper tvw = (VideoWrapper)wid2Video.get(tw);
            if (null != tvw) {
                tvw = tvw.clone().setPid((String)tp);
            }
            pid2VideoCard.put(tp, tvw);
        });
        return pid2VideoCard;
    }
}

