package com.jz.jar.media.tool;

import com.jz.common.utils.text.StringTools;
import com.jz.jar.media.wrapper.VideoWrapper;
import com.jz.jooq.media.tables.pojos.MediaVideo;
import com.jz.jooq.media.tables.pojos.UploadVideo;

/**
 * @Title VideoTool
 * @Package com.jz.jar.media.tool
 * @author tangjunfeng
 * @date 2018年9月11日 下午4:14:38
 * @version V1.0
 */
public class VideoTool {

	private static String getSnapshotName(int cnt) {
		return (cnt < 10 ? "0000" : "000") + cnt;
	}

	public static void getUploadVideoDefault(VideoWrapper wrapper) {
		wrapper.setSnapshotUrl(AliyunBean.getImagesUrl("playabc/sys/upload_video.png", null));
	}

	private static void getSnapshotUrl(VideoWrapper wrapper, String snapshotUrl, Integer cnt,
			PictureCompress compress) {
		if (StringTools.isEmptyAndBlank(snapshotUrl))
			return;
		// 图片地址
		cnt = null == cnt || cnt <= 0 ? 1 : cnt;
		String tempUrl = snapshotUrl.replace("{Count}", getSnapshotName(cnt));
		wrapper.setSnapshotUrl(AliyunBean.getImagesUrl(tempUrl, compress));
	}

	public static void getSnapshotUrl(String uid, UploadVideo video, VideoWrapper wrapper) {
		int cnt = 1;
		if (StringTools.isNotEmptyAndBlank(uid) && null != video.getSnapshotCnt())
			cnt = Math.abs(uid.hashCode()) % video.getSnapshotCnt();
		getSnapshotUrl(wrapper, video.getSnapshotUrl(), cnt, PictureCompress._30);
	}

	public static void getSnapshotUrl(String uid, MediaVideo video, VideoWrapper wrapper) {
		if (null != video.getSelectedSnapshot()) { // 已经选择了视频封面
			wrapper.setSnapshotUrl(AliyunBean.getImagesUrl(video.getSelectedSnapshot(), PictureCompress._510x280));
			return;
		}
		// 默认使用第一张图
		int cnt = 1;
		if (StringTools.isNotEmptyAndBlank(uid)) { // 未选择视频封面，就随机给一张
			cnt = Math.abs(uid.hashCode()) % video.getSnapshotCnt();
		}
		getSnapshotUrl(wrapper, video.getSnapshotUrl(), cnt, PictureCompress._510x280);
	}

	/** 获取视频的相关文件路径 */
	public static void getVideoUrl(MediaVideo video, VideoWrapper wrapper) {
		getVideoUrl(wrapper, video.getHd(), video.getNormal(), video.getLow(), video.getAudit());
	}

	/** 获取视频的相关文件路径 */
	public static void getVideoUrl(UploadVideo video, VideoWrapper wrapper) {
		getVideoUrl(wrapper, video.getHd(), video.getNormal(), video.getLow(), video.getAudit());
	}

	/** 获取视频的相关文件路径 */
	private static void getVideoUrl(VideoWrapper wrapper, String hd, String normal, String low, String audit) {
		// 一个小时
		int expireSeconds = 3600;
		// 视频地址
		wrapper.setHd(AliyunBean.getMediaCdnAuthUrl(hd, expireSeconds));
		wrapper.setNormal(AliyunBean.getMediaCdnAuthUrl(normal, expireSeconds));
		wrapper.setLow(AliyunBean.getMediaCdnAuthUrl(low, expireSeconds));
		// 音频地址
		wrapper.setAudit(AliyunBean.getImagesUrl(audit));
	}

}
