package com.jz.live.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jooq.live.tables.pojos.LiveProduct;
import com.jz.live.repository.LiveProductRepository;

@Lazy
@Service
public class LiveProductService {

	@Autowired
	private LiveProductRepository liveProductRepository;

	public List<String> getPidsByProduct(String lid) {
		return liveProductRepository.getPidsByProduct(lid);
	}

	public void onlineProduct(String lid, String pid) {
		liveProductRepository.onlineProduct(lid, pid);
	}

	public void offlineProduct(String lid, String pid) {
		liveProductRepository.offlineProduct(lid, pid);
	}

	public List<String> getLidsByPid(String pid) {
		return liveProductRepository.getLidsByPid(pid);
	}

	public LiveProduct getLiveProduct(String lid, String pid) {
		return liveProductRepository.getLiveProduct(lid, pid);
	}

	public void setWindowProduct(String lid, String pid) {
		liveProductRepository.setWindowProduct(lid, pid);
	}

	public void cancelWindowProduct(String lid, String pid) {
		liveProductRepository.cancelWindowProduct(lid, pid);
	}

	public LiveProduct getLiveWindowProduct(String lid) {
		return liveProductRepository.getLiveWindowProduct(lid);
	}

}
