/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jooq;

import com.jz.jooq.DBProperty;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.jooq.ConnectionProvider;
import org.jooq.DSLContext;
import org.jooq.SQLDialect;
import org.jooq.Schema;
import org.jooq.conf.MappedSchema;
import org.jooq.conf.RenderMapping;
import org.jooq.conf.Settings;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.DSL;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.ProxoolFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class DBUtil {
    static final Logger log = LoggerFactory.getLogger(DBUtil.class);
    private static DSLContext executor;
    private static ComboPooledDataSource ds;

    public static DSLContext getExecutor(Schema scheme) {
        if (executor == null) {
            Settings settings = new Settings().withRenderMapping(new RenderMapping().withSchemata(new MappedSchema[]{new MappedSchema().withInput(scheme.getName()).withOutput(DBProperty.getScheme())}));
            if ("c3p0".equalsIgnoreCase(DBProperty.getDataSourceType())) {
                executor = DSL.using((DataSource)DBUtil.getDataSource(), (SQLDialect)SQLDialect.MYSQL, (Settings)settings);
            } else {
                DBUtil.initProxoolDataSource("com.mysql.jdbc.Driver", DBProperty.getMysqlUrl(), DBProperty.getMysqlUser(), DBProperty.getMysqlPassword());
                executor = DSL.using((ConnectionProvider)new ProxoolProvider(), (SQLDialect)SQLDialect.MYSQL, (Settings)settings);
            }
        }
        return executor;
    }

    public static synchronized ComboPooledDataSource getDataSource() {
        if (ds == null) {
            ds = new ComboPooledDataSource();
            String mysqlurl = DBProperty.getMysqlUrl();
            ds.setJdbcUrl(mysqlurl);
            ds.setUser(DBProperty.getMysqlUser());
            ds.setPassword(DBProperty.getMysqlPassword());
            ds.setMaxStatements(180);
            ds.setMaxStatementsPerConnection(10);
            ds.setMinPoolSize(5);
            ds.setIdleConnectionTestPeriod(60);
            ds.setPreferredTestQuery("select CURRENT_DATE");
            ds.setAcquireIncrement(5);
            ds.setMaxPoolSize(20);
        }
        return ds;
    }

    public static synchronized Connection getProxoolDataSource() {
        Connection connection = null;
        try {
            connection = DriverManager.getConnection("proxool." + DBProperty.getProxoolAlias());
        }
        catch (SQLException e) {
            log.error("initProxoolDataSource error ", (Throwable)e);
        }
        return connection;
    }

    public static synchronized void initProxoolDataSource(String driverClass, String driverUrl, String mysqlUser, String mysqlPassword) {
        Properties info = new Properties();
        info.setProperty("proxool.maximum-connection-count", "20");
        info.setProperty("proxool.house-keeping-test-sql", "select CURRENT_DATE");
        info.setProperty("proxool.test-before-use:", "true");
        info.setProperty("user", mysqlUser);
        info.setProperty("password", mysqlPassword);
        String alias = DBProperty.getProxoolAlias();
        String url = "proxool." + alias + ":" + driverClass + ":" + driverUrl;
        try {
            ProxoolFacade.registerConnectionPool((String)url, (Properties)info);
        }
        catch (ProxoolException e) {
            log.error("initProxoolDataSource error ", (Throwable)e);
        }
    }

    public static class ProxoolProvider
    implements ConnectionProvider {
        private Connection conn = null;

        public Connection acquire() throws DataAccessException {
            if (this.conn == null) {
                this.conn = DBUtil.getProxoolDataSource();
            }
            return this.conn;
        }

        public void release(Connection connection) throws DataAccessException {
            if (this.conn != null) {
                try {
                    this.conn.close();
                }
                catch (SQLException e) {
                    throw new DataAccessException(e.getMessage(), (Throwable)e);
                }
                this.conn = null;
            }
        }
    }
}

